/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.xml

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildHelper
import pl.metaprogramming.codemodel.builder.java.EnumBuildStrategy
import pl.metaprogramming.codemodel.model.java.AnnotationCm
import pl.metaprogramming.codemodel.model.java.EnumItemCm
import pl.metaprogramming.codemodel.model.java.ValueCm
import pl.metaprogramming.metamodel.model.data.EnumType

class XmlEnumBuildStrategy extends EnumBuildStrategy {
    @Override
    void makeImplementation(ClassCmBuildHelper<EnumType> builder) {
        super.makeImplementation(builder)
        builder.addAnnotation(new AnnotationCm('javax.xml.bind.annotation.XmlEnum'))
        builder.addAnnotation(new AnnotationCm('javax.xml.bind.annotation.XmlType', [name: ValueCm.escaped(builder.metaModel.code)]))
    }

    @Override
    EnumItemCm toItem(ClassCmBuildHelper<EnumType> builder, String value) {
        def item = super.toItem(builder, value)
        if (value != item.name) {
            item.annotations.add(new AnnotationCm(
                    'javax.xml.bind.annotation.XmlEnumValue',
                    [value: ValueCm.escaped(value)]
            ))
        }
        item
    }
}
