/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.spring

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildHelper
import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.codemodel.builder.java.mapper.MappersBuildStrategy
import pl.metaprogramming.codemodel.model.java.AnnotationCm
import pl.metaprogramming.codemodel.model.java.ClassCd
import pl.metaprogramming.codemodel.model.java.FieldCm
import pl.metaprogramming.codemodel.model.java.JavaDefs
import pl.metaprogramming.codemodel.model.java.MethodCm
import pl.metaprogramming.metamodel.model.rest.Operation

interface SpringDefs {

    AnnotationCm ANNOT_REST_CONTROLLER = new AnnotationCm('org.springframework.web.bind.annotation.RestController')
    AnnotationCm ANNOT_AUTOWIRED = new AnnotationCm('org.springframework.beans.factory.annotation.Autowired')
    AnnotationCm ANNOT_BEAN = new AnnotationCm('org.springframework.context.annotation.Bean')
    AnnotationCm ANNOT_CONFIGURATION = new AnnotationCm('org.springframework.context.annotation.Configuration')

    String ANNOT_VALUE = "org.springframework.beans.factory.annotation.Value"

    ClassCd RESPONSE_ENTITY = new ClassCd('org.springframework.http.ResponseEntity')

    ClassCd T_MULTIPART_FILE = new ClassCd('org.springframework.web.multipart.MultipartFile')

    List<String> REST_CONTROLLER_IMPORTS = [
            'org.springframework.web.bind.annotation.*',
            'org.springframework.http.*']

    ClassCmBuildStrategy RESPONSE_MAPPER_BUILDER = MappersBuildStrategy.byMethodCmBuilder({ ClassCmBuildHelper<Operation> builder ->
        [new ResponseEntityMapperBuilder(builder)]
    })

    ClassCmBuildStrategy VALIDATION_RESPONSE_MAPPER_BUILDER = MappersBuildStrategy.byMethodCmBuilder({ ClassCmBuildHelper<Operation> builder ->
        [new ResponseEntityForValidationResultMapperBuilder(builder)]
    })


    MappersBuildStrategy MULTIPART_FILE_MAPPER = MappersBuildStrategy.byMethods([new MethodCm(
            name: 'toBytes',
            resultType: JavaDefs.T_BYTE_ARRAY,
            params: [new FieldCm(name: 'file', type: T_MULTIPART_FILE)],
            implDependencies: [new ClassCd('java.io.IOException')],
            implBody: '''try {
    return file != null ? file.getBytes() : null;
} catch (IOException e) {
    throw new RuntimeException(e);
}'''
    )])
}
