/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.spring

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildHelper
import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.codemodel.model.java.AnnotationCm
import pl.metaprogramming.codemodel.model.java.ValueCm

@Singleton
class ScopePrototypeBuildStrategy extends ClassCmBuildStrategy<Object> {

    static final AnnotationCm ANNOTATION = new AnnotationCm('org.springframework.context.annotation.Scope', [
            value    : ValueCm.value('ConfigurableBeanFactory.SCOPE_PROTOTYPE'),
            proxyMode: ValueCm.value('ScopedProxyMode.TARGET_CLASS')
    ]
    )

    static final List<String> IMPORTS = [
            'org.springframework.beans.factory.config.ConfigurableBeanFactory',
            'org.springframework.context.annotation.ScopedProxyMode',
    ]

    @Override
    void makeImplementation(ClassCmBuildHelper builder) {
        builder.addAnnotation(ANNOTATION)
        builder.addImports(IMPORTS)
    }
}
