/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.spring

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildHelper
import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.codemodel.model.java.FieldCm
import pl.metaprogramming.codemodel.model.java.MethodCm
import pl.metaprogramming.metamodel.model.rest.Operation

import static pl.metaprogramming.codemodel.builder.java.ClassType.*
import static pl.metaprogramming.codemodel.builder.java.spring.SpringDefs.ANNOT_REST_CONTROLLER
import static pl.metaprogramming.codemodel.builder.java.spring.SpringDefs.REST_CONTROLLER_IMPORTS

class RestControllerMoBuildStrategy extends ClassCmBuildStrategy<List<Operation>> {

    @Override
    void makeImplementation(ClassCmBuildHelper<List<Operation>> builder) {
        builder.addAnnotation(ANNOT_REST_CONTROLLER)
        builder.addImports(REST_CONTROLLER_IMPORTS)

        FieldCm serviceField = builder.injectDependency(builder.getClass(FACADE))

        builder.addMethods(builder.metaModel.collect { new RestControllerMethodBuilder(it, builder, serviceField).make() } as MethodCm[])
    }


    static class RestControllerMethodBuilder extends AbstractControllerMethodBuilder {

        FieldCm serviceField

        RestControllerMethodBuilder(
                Operation operation,
                ClassCmBuildHelper classBuilder,
                FieldCm serviceField) {
            super(operation, classBuilder)
            this.serviceField = serviceField
        }

        void prepareImplBody() {
            def validationResultMapperField = inject(VALIDATION_RESULT_MAPPER)
            def mapperField = inject(REST_REQUEST_MAPPER)
            def validatorField = inject(REST_REQUEST_VALIDATOR)
            def resultMapperField = inject(RESPONSE_MAPPER)
            def restRequestHandler = classBuilder.getClass(REST_REQUEST_HANDLER_TEMPLATE)
            methodCm.implDependencies = [restRequestHandler]
            implBodyBuf.add("return ${restRequestHandler.className}.handle(").indent(2)
            implBodyBuf.newLine("${mapperField.name}.map2${getClassName(REST_REQUEST_DTO)}(${getParamsChain()}),")
            implBodyBuf.newLine(validatorField ? "${validatorField.name}::validate," : 'v -> null,')
            implBodyBuf.newLine("${validationResultMapperField.name}::map,")
            implBodyBuf.newLine("${mapperField.name}::map2${getClassName(REQUEST_DTO)},")
            implBodyBuf.newLine("${serviceField.name}::${methodCm.name},")
            implBodyBuf.newLine("${resultMapperField.name}::map);")
        }

    }

}
