/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.spring

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildHelper
import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.metamodel.model.rest.Operation

import static pl.metaprogramming.codemodel.builder.java.ClassType.*
import static pl.metaprogramming.codemodel.builder.java.spring.SpringDefs.ANNOT_REST_CONTROLLER

class RestControllerBuildStrategy extends ClassCmBuildStrategy<Operation> {

    @Override
    void makeImplementation(ClassCmBuildHelper<Operation> builder) {
        builder.addAnnotation(ANNOT_REST_CONTROLLER)
        builder.addMethods(new HandlerMethodBuilder(builder.metaModel, builder).make())
    }

    static class HandlerMethodBuilder extends AbstractControllerMethodBuilder {
        HandlerMethodBuilder(Operation operation, ClassCmBuildHelper classBuilder) {
            super(operation, classBuilder)
        }

        @Override
        void prepareImplBody() {
            def request = transform(methodCm.params, REST_REQUEST_DTO, 'request')
            def validationResult = transform(request, getClass(VALIDATION_RESULT), 'validationResult')
            def serviceCall = transform(transform(request, REQUEST_DTO), RESPONSE_DTO)
            implBodyBuf
                    .newLine(declare(request))
                    .newLine(declare(validationResult))
                    .ifElseValue("return ${validationResult.name}.isValid()",
                            transform(serviceCall, SpringDefs.RESPONSE_ENTITY).expression,
                            transform(validationResult, SpringDefs.RESPONSE_ENTITY).expression + ';')
        }
    }

}
