/*
 * Copyright (c) 2020 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.spring

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildHelper
import pl.metaprogramming.codemodel.builder.java.ClassType
import pl.metaprogramming.codemodel.builder.java.method.BaseMethodCmBuilder
import pl.metaprogramming.codemodel.model.java.FieldCm
import pl.metaprogramming.codemodel.model.java.MethodCm

import static pl.metaprogramming.codemodel.model.java.JavaDefs.ANNOT_NON_NULL

class ResponseEntityForValidationResultMapperBuilder extends BaseMethodCmBuilder {

    ResponseEntityForValidationResultMapperBuilder(ClassCmBuildHelper classCmBuilder) {
        super(classCmBuilder)
    }

    @Override
    protected MethodCm prepareMethodCM() {
        new MethodCm(
                name: 'map',
                resultType: SpringDefs.RESPONSE_ENTITY,
                params: [new FieldCm(name: 'validationResult', type: getClass(ClassType.VALIDATION_RESULT), annotations: [ANNOT_NON_NULL])],
        )
    }

    @Override
    protected void prepareImplBody() {
        implBodyBuf.addLines('return ResponseEntity')
                .indent(2).addLines(
                '.status(validationResult.getStatus())',
                '.body(validationResult.getMessage());   // FIXME and remove \'@Generated\' annotation')
    }
}
