/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.spring


import pl.metaprogramming.codemodel.builder.java.ClassCmBuildHelper
import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.codemodel.builder.java.method.BaseMethodCmBuilder
import pl.metaprogramming.codemodel.model.java.FieldCm
import pl.metaprogramming.codemodel.model.java.MethodCm
import pl.metaprogramming.metamodel.model.rest.Operation

import static pl.metaprogramming.codemodel.builder.java.ClassType.REQUEST_DTO
import static pl.metaprogramming.codemodel.builder.java.ClassType.RESPONSE_DTO
import static pl.metaprogramming.codemodel.model.java.JavaDefs.ANNOT_NON_NULL

@Singleton
class FacadeEmptyImplBuildStrategy extends ClassCmBuildStrategy<List<Operation>> {

    @Override
    void makeImplementation(ClassCmBuildHelper<List<Operation>> builder) {
        builder.metaModel.each {
            builder.addMethods(new EmptyMethodBuilder(it, builder).make())
        }
    }

    class EmptyMethodBuilder extends BaseMethodCmBuilder<Operation> {
        EmptyMethodBuilder(Operation operation, ClassCmBuildHelper<List<Operation>> serviceBuilder) {
            super(operation, serviceBuilder)
        }

        MethodCm prepareMethodCM() {
            new MethodCm(
                    name: metaModel.code,
                    description: metaModel.description,
                    resultType: getClass(RESPONSE_DTO),
                    params: [new FieldCm(name: 'request', type: getClass(REQUEST_DTO), annotations: [ANNOT_NON_NULL])],
            )
        }
    }
}
