/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.rest

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildHelper
import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.codemodel.model.java.ClassCd
import pl.metaprogramming.codemodel.model.java.FieldCm

import static pl.metaprogramming.codemodel.model.java.JavaDefs.*

class RestResponseGenericBuilder extends ClassCmBuildStrategy {

    @Override
    void makeImplementation(ClassCmBuildHelper builder) {
        builder.addInterfaces(I_SERIALIZABLE)
        builder.setGenericParams(GENERIC_T)
        builder.addFields(
                new FieldCm(name: 'status', type: T_INTEGER, annotations: [ANNOT_NON_NULL]),
                new FieldCm(name: 'body', type: GENERIC_T, annotations: [ANNOT_NULLABLE]),
                new FieldCm(name: 'headers', type: new ClassCd(T_MAP, [T_STRING, T_STRING]), annotations: [ANNOT_NULLABLE]))
    }
}
