/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.rest

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildHelper
import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.codemodel.model.java.ClassCm
import pl.metaprogramming.metamodel.model.data.ObjectType

import static pl.metaprogramming.codemodel.builder.java.ClassType.*

@Singleton
class RestDtoValidatorBuilder extends ClassCmBuildStrategy<ObjectType> {

    @Override
    void makeImplementation(ClassCmBuildHelper<ObjectType> builder) {
        builder.addInterfaces(builder.getGenericClass(VALIDATION_CHECKER, [REST_DTO]))
        builder.addMethods(new CheckMethodBuilder(builder.metaModel, builder.getClass(REST_DTO, builder.metaModel) as ClassCm, builder).make())
        builder.addImportStatic(builder.getClass(VALIDATION_COMMON_CHECKERS))
    }

}
