/*
 * Copyright (c) 2020 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.rest

import pl.metaprogramming.codemodel.model.java.ClassCd
import pl.metaprogramming.metamodel.model.data.DataSchema

import java.util.function.Function

class CustomValidators {

    static Map<Function<DataSchema,Boolean>, ClassCd> validators = [:]

    static ClassCd getValidator(DataSchema dataSchema) {
        def result = validators.findAll { it.key.apply(dataSchema) }.values()
        assert result.size() <= 1, "Too many validators ($result) for $dataSchema"
        result ? result[0] : null
    }
}
