/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.mapper

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildHelper
import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.codemodel.builder.java.method.DummyMethodCmBuilder
import pl.metaprogramming.codemodel.builder.java.method.MapperMethodBuilder
import pl.metaprogramming.codemodel.model.java.ClassCm
import pl.metaprogramming.codemodel.model.java.FieldCm
import pl.metaprogramming.codemodel.model.java.JavaDefs
import pl.metaprogramming.codemodel.model.java.MethodCm
import pl.metaprogramming.metamodel.model.data.ObjectType

import static pl.metaprogramming.codemodel.builder.java.ClassType.*

class MappersBuilders {

    static ClassCmBuildStrategy REST_REQUEST_MAPPER_BUILDER = MappersBuildStrategy.byMethodCmBuilder({ ClassCmBuildHelper<ObjectType> builder ->
        [new MapperMethodBuilder(builder, null, REST_REQUEST_DTO),
         new MapperMethodBuilder(builder, REST_REQUEST_DTO, REQUEST_DTO)]
    })

    static ClassCmBuildStrategy REST_DTO_MAPPER_BUILDER = MappersBuildStrategy.byMethodCmBuilder({ ClassCmBuildHelper<ObjectType> builder ->
        def jsonDtoClass = builder.getClass(REST_DTO)
        def dtoClass = builder.getClass(DTO) as ClassCm

        if (jsonDtoClass instanceof ClassCm) {
            [new DummyMethodCmBuilder(new MethodCm(
                    name: "map2$jsonDtoClass.className",
                    resultType: jsonDtoClass,
                    params: [new FieldCm(name: 'value', type: dtoClass)],
                    implBody: "return value == null ? null : map(new ${jsonDtoClass.className}(), value);"
            )),
             new DummyMethodCmBuilder(new MethodCm(
                     name: "map2$dtoClass.className",
                     resultType: dtoClass,
                     params: [new FieldCm(name: 'value', type: jsonDtoClass)],
                     implBody: "return value == null ? null : map(new ${dtoClass.className}(), value);"
             )),
             new MapperMethodBuilder(builder, REST_DTO, DTO, true),
             new MapperMethodBuilder(builder, DTO, REST_DTO, true),
            ]
        } else if (jsonDtoClass == JavaDefs.T_STRING) {
            [new DummyMethodCmBuilder(new MethodCm(
                    name: "map2$jsonDtoClass.className",
                    resultType: jsonDtoClass,
                    params: [new FieldCm(name: 'value', type: dtoClass)],
                    implBody: 'throw new RuntimeException("Not implemented");'
            )),
             new DummyMethodCmBuilder(new MethodCm(
                     name: "map2$dtoClass.className",
                     resultType: dtoClass,
                     params: [new FieldCm(name: 'value', type: jsonDtoClass)],
                     implBody: 'throw new RuntimeException("Not implemented");'
             ))]
        } else {
            throw new RuntimeException("Unsupported JSON_DTO class: $jsonDtoClass")
        }
    })
}
