/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.mapper

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.codemodel.builder.java.ClassCmBuildHelper
import pl.metaprogramming.codemodel.builder.java.method.MethodCmBuilder
import pl.metaprogramming.codemodel.model.java.MethodCm

import java.util.function.Function

class MappersBuildStrategy<T> extends ClassCmBuildStrategy<T> {

    static <T> MappersBuildStrategy<T> byMethods(List<MethodCm> methods) {
        new MappersBuildStrategy<T>(methods: methods)
    }

    static <T> MappersBuildStrategy<T> byMethodCmBuilder(Function<ClassCmBuildHelper<T>, List<MethodCmBuilder>> methodBuildersProvider) {
        new MappersBuildStrategy<T>(methodBuildersProvider: methodBuildersProvider)
    }

    protected List<MethodCm> methods
    protected Function<ClassCmBuildHelper<T>, List<MethodCmBuilder>> methodBuildersProvider

    @Override
    void makeDeclaration(ClassCmBuildHelper<T> builder) {
        def methodsToAdd = methods
        if (!methods) {
            builder.methodBuilders = methodBuildersProvider.apply(builder)
            methodsToAdd = builder.methodBuilders.collect { it.makeDeclaration() }
        }
        builder.addMappers(methodsToAdd as MethodCm[])
    }

    @Override
    void makeImplementation(ClassCmBuildHelper<T> builder) {
        if (builder.methodBuilders) {
            builder.methodBuilders.each { it.makeImplementation() }
        }
    }
}
