/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.dto

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildHelper
import pl.metaprogramming.codemodel.model.java.FieldCm
import pl.metaprogramming.metamodel.model.data.DataSchema
import pl.metaprogramming.metamodel.model.data.ObjectType
import pl.metaprogramming.metamodel.model.rest.Parameter

import static pl.metaprogramming.codemodel.builder.java.ClassType.REST_DTO
import static pl.metaprogramming.codemodel.builder.java.MetaModelAttribute.JAVA_NAME

@Singleton
class RawDtoBuildStrategy extends BaseDtoBuildStrategy {

    @Override
    void addField(ClassCmBuildHelper<ObjectType> builder, DataSchema schema) {
        addDescriptiveFields(builder, schema, getParamName(schema))
        builder.addFields new FieldCm(
                name: schema.getAttribute(JAVA_NAME),
                metaModel: schema,
                type: builder.getClass(REST_DTO, schema.dataType))
    }

    static String getParamName(DataSchema schema) {
        schema instanceof Parameter ? "$schema.name ($schema.location parameter)" : schema.code
    }

}
