/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.dto

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildStrategy
import pl.metaprogramming.codemodel.builder.java.ClassCmBuildHelper
import pl.metaprogramming.codemodel.model.java.AnnotationCm
import pl.metaprogramming.codemodel.model.java.ClassCm

import static pl.metaprogramming.codemodel.model.java.JavaDefs.*

@Singleton
class LombokDataBuildStrategy extends ClassCmBuildStrategy<Object> {

    static final List<AnnotationCm> ANNOTATIONS = [
            ANNOT_LB_DATA, ANNOT_LB_NO_ARGS_CONTR, ANNOT_LB_ACCESSORS
    ]

    @Override
    void makeImplementation(ClassCmBuildHelper builder) {
        builder.addAnnotations(ANNOTATIONS)
        if (isAnnotatedByData(builder.superClass)) {
            builder.addAnnotation(ANNOT_LB_EQ_AND_HC)
        }

    }

    static boolean isAnnotatedByData(def clazz) {
        clazz instanceof ClassCm && clazz.annotations.any { it == ANNOT_LB_DATA}
    }

}
