/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.dto

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildHelper
import pl.metaprogramming.codemodel.model.java.AnnotationCm
import pl.metaprogramming.codemodel.model.java.FieldCm
import pl.metaprogramming.codemodel.model.java.ValueCm
import pl.metaprogramming.metamodel.model.data.DataSchema
import pl.metaprogramming.metamodel.model.data.ObjectType

import static pl.metaprogramming.codemodel.builder.java.ClassType.REST_DTO
import static pl.metaprogramming.codemodel.builder.java.MetaModelAttribute.ORIGINAL_NAME_FIELD
import static pl.metaprogramming.codemodel.builder.java.MetaModelAttribute.JAVA_NAME

@Singleton
class JsonDtoBuildStrategy extends BaseDtoBuildStrategy {

    static final String CLASS_ANNOTATION = 'com.fasterxml.jackson.annotation.JsonAutoDetect'
    static final String FIELD_ANNOTATION = 'com.fasterxml.jackson.annotation.JsonProperty'
    static final AnnotationCm ANNOTATION = new AnnotationCm(CLASS_ANNOTATION, [fieldVisibility: ValueCm.value('JsonAutoDetect.Visibility.NONE')])

    @Override
    void makeImplementation(ClassCmBuildHelper<ObjectType> builder) {
        super.makeImplementation(builder)
        builder.addAnnotation(ANNOTATION)
    }

    void addField(ClassCmBuildHelper<ObjectType> builder, DataSchema schema) {
        addDescriptiveFields(builder, schema, schema.code)
        builder.addFields new FieldCm(
                metaModel: schema,
                name: schema.getAttribute(JAVA_NAME),
                type: builder.getClass(REST_DTO, schema.dataType),
                annotations: [new AnnotationCm(FIELD_ANNOTATION, [value: ValueCm.value(schema.getAttribute(ORIGINAL_NAME_FIELD))])])
    }
}
