/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.dto

import pl.metaprogramming.codemodel.builder.java.ClassCmBuildHelper
import pl.metaprogramming.codemodel.model.java.FieldCm
import pl.metaprogramming.metamodel.model.data.DataSchema
import pl.metaprogramming.metamodel.model.data.ObjectType

import static pl.metaprogramming.codemodel.builder.java.ClassType.DTO
import static pl.metaprogramming.codemodel.builder.java.ClassType.ENUM
import static pl.metaprogramming.codemodel.builder.java.MetaModelAttribute.JAVA_NAME
import static pl.metaprogramming.codemodel.model.java.JavaDefs.ANNOT_NON_NULL
import static pl.metaprogramming.codemodel.model.java.JavaDefs.ANNOT_NULLABLE

@Singleton
class DtoBuildStrategy extends BaseDtoBuildStrategy {

    @Override
    void makeImplementation(ClassCmBuildHelper<ObjectType> builder) {
        super.makeImplementation(builder)
        builder.setComment(builder.metaModel.description)
    }

    void addField(ClassCmBuildHelper<ObjectType> builder, DataSchema schema) {
        builder.addFields new FieldCm(
                metaModel: schema,
                name: schema.getAttribute(JAVA_NAME),
                description: schema.description,
                annotations: [schema.isRequired ? ANNOT_NON_NULL : ANNOT_NULLABLE],
                type: builder.getClass(isEnum(schema) ? ENUM : DTO, schema.dataType))
    }
}
