/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.config

import pl.metaprogramming.codemodel.builder.java.ClassBuilderConfig
import pl.metaprogramming.codemodel.model.java.index.DataTypeMapper

class JavaModuleConfig {
    Map<Object, ClassBuilderConfig> classBuilderConfigs
    Map classTypesMap
    DataTypeMapper dataTypeMapper
    Map params = [:]

    void setConfigs(Collection<ClassBuilderConfig> configs) {
        classBuilderConfigs = configs.collectEntries {
            [(it.classType): it]
        }
    }

    ClassBuilderConfig getConfig(def classType) {
        def fixedClassType = mapClassType(classType)
        assert classBuilderConfigs.containsKey(fixedClassType), "No generation configuration for class type: $fixedClassType"
        def config = classBuilderConfigs.get(fixedClassType)
        config.dataTypeMapper = config.dataTypeMapper ?: dataTypeMapper
        config
    }

    def mapClassType(def classType) {
        classTypesMap && classTypesMap.containsKey(classType) ? classTypesMap.get(classType) : classType
    }
}
