/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.config

import pl.metaprogramming.codemodel.builder.java.spring.SpringDefs
import pl.metaprogramming.codemodel.model.java.ClassCd
import pl.metaprogramming.codemodel.model.java.JavaDefs
import pl.metaprogramming.codemodel.model.java.index.DataTypeMapper
import pl.metaprogramming.metamodel.model.data.DataType
import pl.metaprogramming.metamodel.model.data.EnumType

class JavaDataTypeMappers {

    static Map<DataType, ClassCd> DATA_TYPE_TO_JAVA_TYPE = [
            (DataType.TEXT)     : JavaDefs.T_STRING,
            (DataType.DATE_TIME): JavaDefs.T_DATE,
            (DataType.DECIMAL)  : JavaDefs.T_BIG_DECIMAL,
            (DataType.FLOAT)    : JavaDefs.T_FLOAT,
            (DataType.DOUBLE)   : JavaDefs.T_DOUBLE,
            (DataType.INT32)    : JavaDefs.T_INTEGER,
            (DataType.INT64)    : JavaDefs.T_LONG,
            (DataType.BOOLEAN)  : JavaDefs.T_BOOLEAN,
            (DataType.BINARY)   : JavaDefs.T_BYTE_ARRAY,
    ]

    static DataTypeMapper JAVA_DATA_TYPE_MAPPER = { DataType it -> DATA_TYPE_TO_JAVA_TYPE.get(it) } as DataTypeMapper
    static DataTypeMapper REST_DATA_TYPE_MAPPER = { DataType it ->
        it == DataType.BINARY ? SpringDefs.T_MULTIPART_FILE
                : DATA_TYPE_TO_JAVA_TYPE.containsKey(it) || it instanceof EnumType ? JavaDefs.T_STRING
                : null
    } as DataTypeMapper

}
