/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java.config

import pl.metaprogramming.codemodel.builder.java.EnumValueInterfaceBuilder
import pl.metaprogramming.codemodel.builder.java.mapper.BaseDataMappersBuilder
import pl.metaprogramming.codemodel.builder.java.rest.RestResponseGenericBuilder
import pl.metaprogramming.codemodel.builder.java.spring.SpringDefs

import static pl.metaprogramming.codemodel.builder.java.ClassType.*

class CommonsModuleConfigurator extends JavaModuleConfigurator<CommonsModuleConfigurator> {

    CommonsModuleConfigurator init() {
        addComponent(prepareFixedClass(REST_MAPPER, 'BaseDataMapper', BaseDataMappersBuilder.instance, SpringDefs.MULTIPART_FILE_MAPPER))
        addFixedClass(ENUM_VALUE_INTERFACE, 'EnumValue', EnumValueInterfaceBuilder.instance)
        addFixedClass(VALUE_HOLDER_TEMPLATE, 'ValueHolder')
        addLombokData(prepareFixedClass(REST_RESPONSE_TEMPLATE, 'RestResponse', new RestResponseGenericBuilder()))

        addFixedClass(VALIDATION_CONTEXT, 'ValidationContext', [VALUE_HOLDER_TEMPLATE])
        addFixedClass(VALIDATION_CHECKER, 'Checker')
        addFixedClass(VALIDATION_SIMPLE_CHECKER, 'SimpleChecker')
        addFixedClass(VALIDATION_FIELD, 'Field')
        addFixedClass(VALIDATION_RESULT, 'ValidationResult')
        addFixedClass(VALIDATION_VALIDATOR, 'Validator')
        addFixedClass(VALIDATION_COMMON_CHECKERS, 'CommonCheckers', [ENUM_VALUE_INTERFACE, RESPONSE_DTO])

        addFixedClass(REST_REQUEST_HANDLER_TEMPLATE, 'RestRequestHandler', [VALUE_HOLDER_TEMPLATE, REST_RESPONSE_TEMPLATE, VALIDATION_RESULT])

        addComponent(prepareFixedClass(VALIDATION_RESULT_MAPPER, 'ValidationResultMapper', SpringDefs.VALIDATION_RESPONSE_MAPPER_BUILDER))
    }

    CommonsModuleConfigurator setRootPackage(String rootPackage) {
        super.setRootPackage(rootPackage)
        setPackage(rootPackage + '.validator',
                VALIDATION_CONTEXT,
                VALIDATION_CHECKER,
                VALIDATION_SIMPLE_CHECKER,
                VALIDATION_FIELD,
                VALIDATION_RESULT,
                VALIDATION_RESULT_MAPPER,
                VALIDATION_VALIDATOR,
                VALIDATION_COMMON_CHECKERS)
        this
    }
}
