/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java

enum ClassType {

    // multiple occurrence class types
    REST_CONTROLLER_MO,                    // all operation from group in one controller class
    REST_CONTROLLER,                       // controller class for one operation

    FACADE,
    FACADE_IMPL,
    ENUM,
    DTO,
    REQUEST_DTO,
    RESPONSE_DTO,

    REST_MAPPER,                        // REST_DTO <-> REST_REQUEST_DTO
    REST_REQUEST_MAPPER,                // REQUEST_REST_DTO -> REQUEST_DTO
    RESPONSE_MAPPER,                    // RESPONSE_DTO -> ResponseEntity

    REST_REQUEST_DTO,
    REST_DTO,
    REST_REQUEST_VALIDATOR,
    REST_DTO_VALIDATOR,

    XML_ENUM,
    XML_DTO,
    XML_OBJECT_FACTORY,
    WS_CLIENT,
    WS_CLIENT_CONFIGURATION,

    ENDPOINT_PROVIDER,

    // single occurrence class types
    ENUM_VALUE_INTERFACE,
    VALUE_HOLDER_TEMPLATE,
    REST_RESPONSE_TEMPLATE,
    REST_REQUEST_HANDLER_TEMPLATE,
    VALIDATION_CONTEXT,
    VALIDATION_FIELD,
    VALIDATION_CHECKER,
    VALIDATION_COMMON_CHECKERS,
    VALIDATION_SIMPLE_CHECKER,
    VALIDATION_RESULT,
    VALIDATION_RESULT_MAPPER,           // VALIDATION_RESULT -> ResponseEntity
    VALIDATION_VALIDATOR,
}