/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java


import pl.metaprogramming.codemodel.model.java.ClassCd

import java.util.function.Function

class ClassCmBuildStrategyWrapper<R,T> extends ClassCmBuildStrategy<T> {

    private ClassCmBuildStrategy<R> strategy
    private Function<T, R> metaModelMapper

    static <R,T> ClassCmBuildStrategy<T> wrap(ClassCmBuildStrategy<R> strategy, Function<T, R> metaModelMapper) {
        new ClassCmBuildStrategyWrapper(strategy, metaModelMapper)
    }

    ClassCmBuildStrategyWrapper(ClassCmBuildStrategy<R> strategy, Function<T, R> metaModelMapper) {
        this.strategy = strategy
        this.metaModelMapper = metaModelMapper
    }

    @Override
    void makeDeclaration(ClassCmBuildHelper<T> builder) {
        strategy.makeDeclaration(wrapBuildHelper(builder))
    }

    @Override
    void makeImplementation(ClassCmBuildHelper<T> builder) {
        strategy.makeImplementation(wrapBuildHelper(builder))
    }

    private ClassCmBuildHelper<R> wrapBuildHelper(ClassCmBuildHelper<T> builder) {
        new ClassCmBuildHelperWrapper(builder, metaModelMapper)
    }

    static class ClassCmBuildHelperWrapper<T, R> implements ClassCmBuildHelper<R> {

        @Delegate private ClassCmBuildHelper<T> helper
        private Function<T, R> metaModelMapper

        ClassCmBuildHelperWrapper(ClassCmBuildHelper<T> helper, Function<T, R> metaModelMapper) {
            this.helper = helper
            this.metaModelMapper = metaModelMapper
        }

        @Override
        R getMetaModel() {
            metaModelMapper.apply(helper.metaModel)
        }

        @Override
        ClassCd getClass(Object classType, Object metaModel) {
            metaModel == getMetaModel()
                    ? helper.getClass(classType, helper.metaModel)
                    : helper.getClass(classType, metaModel)
        }
    }
}
