/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder.java

import pl.metaprogramming.codemodel.builder.java.method.MethodCmBuilder
import pl.metaprogramming.codemodel.model.java.*

import java.util.function.Predicate

interface ClassCmBuildHelper<T> {

    ClassCd getBuiltClass()
    T getMetaModel()
    String getMetaModelName()
    def getClassType()

    void addImport(ClassCd classCd) // TODO remove it
    void addImportStatic(ClassCd classCd) // TODO remove it
    void addImports(List<String> imports) // TODO remove it
    void addImports(Object...imports)

    void setComment(String comment)

    void addAnnotation(AnnotationCm annotation)
    void addAnnotations(List<AnnotationCm> annotations)

    void setGenericParams(ClassCd...genericParams)

    void setInterface()
    void addInterfaces(Object...interfaces)
    List<ClassCd> getInterfaces()

    void setSuperClass(Object superClass)
    void setSuperClass(Object superClass, def metaModel)
    ClassCd getSuperClass()

    List<MethodCmBuilder> getMethodBuilders()
    void setMethodBuilders(List<MethodCmBuilder> methodCmBuilders)
    List<MethodCm> getMethods()
    void addMethods(MethodCm...methods)
    void addInheritMapper(List fromClassTypes, Object toClassType, String methodName)
    void addMapper(MethodCmBuilder methodCmBuilder)
    void addMappers(MethodCm...methods)

    void addFields(FieldCm...fields)
    List<FieldCm> findFields(Predicate<FieldCm> predicate)

    void setEnums(List<EnumItemCm> enums)

    FieldCm injectDependency(ClassCd toInject)

    ClassCd getClass(Object classType)
    ClassCd getClass(Object classType, def metaModel)
    Optional<ClassCd> getClassOptional(Object classType)
    ClassCd getGenericClass(Object classType, List genericClassTypes)
    MethodCm findMapper(ClassCd resultType, List<ClassCd> params)

}