/*
 * Copyright (c) 2019 Dawid Walczak.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.metaprogramming.codemodel.builder


import pl.metaprogramming.codemodel.formatter.GspTemplateFormatter
import pl.metaprogramming.codemodel.model.java.ClassCm

import static pl.metaprogramming.codemodel.builder.java.module.JavaModuleBuilder.pkgToDir

abstract class CustomModuleBuilder<T> implements ModuleBuilder<T> {

    static List<CodeGenerationTask> make(List<? extends ClassCm> models, String destCodeDir, String template) {
        def formatter = new GspTemplateFormatter(template)
        def t = getCodeFileExt(template)
        models.collect {
            new CodeGenerationTask(
                    destFilePath: "$destCodeDir/${pkgToDir(it.packageName)}/${it.className}.$t",
                    formatter: formatter,
                    codeModel: it
            )
        }
    }

    static String getCodeFileExt(String template) {
        def t = template.substring(0, template.length()-4)
        t.substring(t.lastIndexOf('.')+1)
    }
}
