<%
 def cm = d.classCd;
%>package ${cm.packageName};

import lombok.Getter;

import javax.annotation.Generated;

@Generated("pl.metaprogramming.codegen")
public class ValidationContext<I> {

    @Getter private ValidationResult result;
    @Getter private I value;
    @Getter private String name;

    ValidationContext(I value) {
        this.value = value;
        this.result = new ValidationResult();
    }

    ValidationContext(I value, String name, ValidationContext<?> parent) {
        this.result = parent.result;
        this.value = value;
        this.name = name;
    }

    protected String getChildName(String childName) {
        return name == null || "requestBody".equals(name) ? childName : name + "." + childName;
    }

    public boolean isValid() {
        return result.isValid();
    }

    @SuppressWarnings("unchecked")
    public void check(ValidationContext context, Checker...checkers) {
        if (context.isValid()) {
            for (Checker checker : checkers) {
                if (!context.isValid() || context.getValue() == null && checker != CommonCheckers.REQUIRED) {
                    break;
                }
                checker.check(context);
            }
        }
    }

    public <T> void check(Field<I,T> field, Checker...checkers) {
        check(new ValidationContext<>(field.getValue(getValue()), getChildName(field.getName()), this), checkers);
    }
}
