<%
 def cm = d.classCd;
%>package ${cm.packageName};

import ${d.ENUM_VALUE_INTERFACE.canonicalName};

import javax.annotation.Generated;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Generated("pl.metaprogramming.codegen")
public class CommonCheckers {

    // see https://www.debuggex.com/r/_G6Mvw1eoYJF2Bgf
    private static Pattern ISO8601 = Pattern.compile("^(?:[1-9]\\\\d{3}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1\\\\d|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[1-9]\\\\d(?:0[48]|[2468][048]|[13579][26])|(?:[2468][048]|[13579][26])00)-02-29)T(?:[01]\\\\d|2[0-3]):[0-5]\\\\d:[0-5]\\\\d(?:|.\\\\d{3})(?:Z|[+-][01]\\\\d:[0-5]\\\\d)\$");

    public static interface DangerousConsumer<T> {
        void accept(T value) throws Exception;
    }

    private static void writeError(ValidationContext ctx, String message) {
        ctx.getResult().setError(400, message);
    }

    public static boolean isNull(Object value) {
        return value == null;
    }

    public static boolean isNotNull(Object value) {
        return !isNull(value);
    }

    public static boolean isNoException(String value, DangerousConsumer<String> consumer) {
        try {
            consumer.accept(value);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    public static Checker<String> noException(DangerousConsumer<String> consumer, String dataType) {
        return new SimpleChecker<>(
                ctx -> isNoException(ctx.getValue(), consumer),
                ctx -> writeError(ctx, String.format("%s is not %s", ctx.getName(), dataType)));
    }

    public static Checker<List> list(Checker...checkers) {
        return new Checker<List>() {
            @Override
            public void check(ValidationContext<List> context) {
                for (int idx = 0; idx < context.getValue().size() && context.isValid(); idx++) {
                    ValidationContext itemCtx = new ValidationContext(
                            context.getValue().get(idx),
                            String.format("%s[%d]", context.getName(), idx),
                            context);
                    context.check(itemCtx, checkers);
                }
            }
        };
    }

    public static Checker<String> dateTime(String dataTimeFormat) {
        if ("ISO8601".equals(dataTimeFormat)) {
            return matches(ISO8601, "should be valid date time in ISO8601 format");
        }
        final SimpleDateFormat sdf = new SimpleDateFormat(dataTimeFormat);
        sdf.setLenient(false);
        return noException(v -> sdf.parse(v), dataTimeFormat);
    }

    public static Checker<String> allow(EnumValue...values) {
        return allow(Stream.of(values).map(EnumValue::getValue).collect(Collectors.toList()));
    }

    public static Checker<String> allow(Collection<String> allowedValues) {
        return new SimpleChecker<>(
                ctx -> allowedValues.contains(ctx.getValue()),
                ctx -> writeError(ctx, ctx.getName() + " should have one of values: " + allowedValues));
    }

    public static Checker<String> allow(Collection<String> allowedValues, Function<String,String> preprocessor) {
        return new SimpleChecker<>(
                ctx -> allowedValues.contains(preprocessor.apply(ctx.getValue())),
                ctx -> writeError(ctx, ctx.getName() + " should have one of values: " + allowedValues));
    }

    public static Checker<String> matches(Pattern pattern) {
        return matches(pattern, "should match pattern: " + pattern.pattern());
    }

    public static Checker<String> matches(Pattern pattern, String errorMessage) {
        return new SimpleChecker<>(
                ctx -> pattern.matcher(ctx.getValue()).matches(),
                ctx -> writeError(ctx, ctx.getName() + " " + errorMessage));
    }

    public static Checker<List> size(Integer minSize, Integer maxSize) {
        return new SimpleChecker<>(
                ctx -> (minSize == null || minSize <= ctx.getValue().size()) &&
                        (maxSize == null || maxSize >= ctx.getValue().size()),
                ctx -> writeError(ctx, ctx.getName() + " " +
                                (minSize != null && minSize >= ctx.getValue().size() ?
                                        ("has not enough elements, min allowed size is " + minSize) :
                                        ("hast too many elements, max allowed size is " + maxSize))));
    }

    public static Checker<String> length(Integer minLength, Integer maxLength) {
        return new SimpleChecker<>(
                ctx -> (minLength == null || minLength <= ctx.getValue().length()) &&
                        (maxLength == null || maxLength >= ctx.getValue().length()),
                ctx -> writeError(ctx, ctx.getName() +
                        (minLength != null && minLength >= ctx.getValue().length() ?
                                (" has too short value, min allowed length is " + minLength) :
                                (" has too long value, max allowed length is " + maxLength))));
    }

    public static <T extends Comparable> Checker<String> range(Function<String,T> mapper, String minValue, String maxValue) {
        final T min = minValue != null ? mapper.apply(minValue) : null;
        final T max = maxValue != null ? mapper.apply(maxValue) : null;
        StringBuffer buffer = new StringBuffer();
        final String message = " should be " +
                (minValue != null && maxValue != null ? (">= " + minValue + " and <= " + maxValue)
                : minValue != null ? (">= " + minValue) : ("<= " + maxValue));
        return new SimpleChecker<>(
                ctx -> {
                    T value = mapper.apply(ctx.getValue());
                    return (minValue == null || min.compareTo(value) <= 0) &&
                            (maxValue == null || max.compareTo(value) >= 0);
                },
                ctx -> writeError(ctx, ctx.getName() + message));
    }

    public static final Checker<Object> REQUIRED = new SimpleChecker<>(
            ctx -> isNotNull(ctx.getValue()),
            ctx -> writeError(ctx,ctx.getName() + " is required"));

    public static final Checker<Object> NOT_ALLOWED = new SimpleChecker<>(
            ctx -> isNotNull(ctx.getValue()),
            ctx -> writeError(ctx,ctx.getName() + " is not allowed"));

    public static final Checker<String> BOOLEAN = allow(Arrays.asList("true", "false"), String::toLowerCase);

    public static final Checker<String> INT32 = noException(Integer::parseInt, "32bit integer");

    public static final Checker<String> INT64 = noException(Long::parseLong, "64bit integer");

    public static final Checker<String> FLOAT = noException(Float::parseFloat, "float");

    public static final Checker<String> DOUBLE = noException(Double::parseDouble, "double");
}
