package pl.metaprogramming.codegen

import java.security.MessageDigest

class HashBuilder {

    private MessageDigest digest

    static String build(String multiLine) {
        new HashBuilder().addLines(multiLine).getHash()
    }

    HashBuilder() {
        digest = MessageDigest.getInstance("MD5")
    }

    HashBuilder addLine(String line) {
        String trimmed = line.trim()
        if (!trimmed.isEmpty()) {
            digest.update(trimmed.getBytes("UTF-8"))
        }
        this
    }

    HashBuilder addLines(String multiLine) {
        multiLine.eachLine { addLine(it) }
        this
    }

    String getHash() {
        String.format("%032x", new BigInteger(1, digest.digest()))
    }
}
