/*
 * Decompiled with CFR 0.152.
 */
package pl.metaprogramming.metamodel.builder;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import pl.metaprogramming.metamodel.builder.ValidationUtils;
import pl.metaprogramming.metamodel.model.data.DataSchema;
import pl.metaprogramming.metamodel.model.data.DataType;
import pl.metaprogramming.metamodel.model.data.ObjectType;
import pl.metaprogramming.metamodel.model.rest.HttpResponse;
import pl.metaprogramming.metamodel.model.rest.Operation;
import pl.metaprogramming.metamodel.model.rest.Parameter;
import pl.metaprogramming.metamodel.model.rest.RestServices;
import pl.metaprogramming.metamodel.model.rest.enums.OperationType;
import pl.metaprogramming.metamodel.model.rest.enums.ParamLocation;

public class RestServicesBuilder
implements GroovyObject {
    private static final String SUB_SCHEMA = "Schema";
    private static final String SUB_PARAM = "Parameter/parameter groups";
    private static final String SUB_OPID = "OperationId";
    private static final String SUB_PATH = "Path";
    private static final String SUB_REQS = "requestBody";
    private static final String SUB_RESP = "responses";
    private static final List<OperationType> OPERATIONS_WITH_BODY;
    private RestServices model;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public RestServicesBuilder() {
        RestServices restServices;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.model = restServices = new RestServices();
    }

    public void addDependency(RestServices model) {
        this.model.getDependencies().add(model);
    }

    public void operation(String operationId, String path, OperationType operationType, String description, Consumer<Operation> configurator) {
        ValidationUtils.checkRestOperationId(operationId, SUB_OPID);
        String errMsgId = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{operationId}, new String[]{" [for operation ", "]"}));
        String resourceCode = RestServicesBuilder.getResourceCode(operationId);
        String operationCode = RestServicesBuilder.getOperationCode(operationId);
        String fixedOperationId = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{resourceCode, operationCode}, new String[]{"", ".", ""}));
        ValidationUtils.addUnique(SUB_OPID, this.model.getImplementations(), operationId);
        ValidationUtils.addUnique(StringGroovyMethods.plus((String)SUB_PATH, (CharSequence)errMsgId), this.model.getPaths(), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{path, operationType}, new String[]{"", ".", ""})));
        Operation operation = new Operation();
        String string = path;
        operation.setPath(string);
        OperationType operationType2 = operationType;
        operation.setOperationType(operationType2);
        String string2 = fixedOperationId;
        operation.setOperationId(string2);
        String string3 = description;
        operation.setDescription(string3);
        List<String> list = this.model.getConsumes();
        operation.setConsumes(list);
        List<String> list2 = this.model.getProduces();
        operation.setProduces(list2);
        Operation operation2 = operation;
        configurator.accept(operation2);
        RestServicesBuilder.checkPathParameters(path, operation2.getParameters(), errMsgId);
        ValidationUtils.requiredElseEmpty(RestServicesBuilder.shouldHaveBodyParam(operation2), operation2.getRequestBody(), StringGroovyMethods.plus((String)SUB_REQS, (CharSequence)errMsgId));
        public final class _operation_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operation_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((Object)((Parameter)it).getLocation()), (Object)((Object)ParamLocation.FORMDATA));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operation_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ValidationUtils.requiredElseEmpty(RestServicesBuilder.shouldHaveFormDataParams(operation2), DefaultGroovyMethods.findAll(operation2.getParameters(), (Closure)new _operation_closure1(this, this)), StringGroovyMethods.plus((String)"should not be formData params", (CharSequence)errMsgId));
        this.model.getOperations().putIfAbsent(resourceCode, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        this.model.getOperations().get(resourceCode).put(operationCode, operation2);
    }

    public static boolean shouldHaveBodyParam(Operation operation) {
        return OPERATIONS_WITH_BODY.contains((Object)operation.getOperationType()) && RestServicesBuilder.shouldHaveBodySchema(operation);
    }

    public static boolean shouldHaveFormDataParams(Operation operation) {
        return OPERATIONS_WITH_BODY.contains((Object)operation.getOperationType()) && !RestServicesBuilder.shouldHaveBodySchema(operation);
    }

    public static boolean shouldHaveBodySchema(Operation operation) {
        return !DefaultGroovyMethods.disjoint((Iterable)ScriptBytecodeAdapter.createList((Object[])new Object[]{"application/json", "application/xml"}), operation.getConsumes());
    }

    public static void checkPathParameters(String path, List<Parameter> parameters, String errMsgId) {
        List pathParams = DefaultGroovyMethods.sort(ValidationUtils.extractHttpPathParams(path));
        public final class _checkPathParameters_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _checkPathParameters_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((Object)ParamLocation.PATH), (Object)((Object)((Parameter)it).getLocation()));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _checkPathParameters_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _checkPathParameters_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _checkPathParameters_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((Parameter)it).getName();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _checkPathParameters_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List declaredPathParams = DefaultGroovyMethods.sort((Iterable)DefaultGroovyMethods.collect((Iterable)DefaultGroovyMethods.findAll(parameters, (Closure)new _checkPathParameters_closure2(RestServicesBuilder.class, RestServicesBuilder.class)), (Closure)new _checkPathParameters_closure3(RestServicesBuilder.class, RestServicesBuilder.class)));
        ValidationUtils.check(ScriptBytecodeAdapter.compareEqual((Object)pathParams, (Object)declaredPathParams), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{path, declaredPathParams}, new String[]{"Mismatch between path value [", "] and declared path parameters ", ""}).plus(errMsgId)));
    }

    public DataSchema dataDef(String code, String description, Map<String, DataSchema> properties) {
        public final class _dataDef_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _dataDef_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                Object k = ((Map.Entry)it).getKey();
                ((DataSchema)((Map.Entry)it).getValue()).setCode(ShortTypeHandling.castToString(k));
                return ((Map.Entry)it).getValue();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _dataDef_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return this.dataDef(code, description, DefaultGroovyMethods.collect(properties, (Closure)new _dataDef_closure4(this, this)));
    }

    public DataSchema dataDef(String code, String description, List<DataSchema> properties) {
        DataSchema dataSchema = new DataSchema();
        ObjectType objectType = new ObjectType();
        List<DataSchema> list = properties;
        objectType.setFields(list);
        String string = description;
        objectType.setDescription(string);
        ObjectType objectType2 = objectType;
        dataSchema.setDataType(objectType2);
        String string2 = description;
        dataSchema.setDescription(string2);
        return this.dataDef(code, dataSchema);
    }

    public DataSchema dataDef(String code, DataSchema data) {
        String string = code;
        data.setCode(string);
        return (DataSchema)ScriptBytecodeAdapter.castToType((Object)ValidationUtils.addUnique(SUB_SCHEMA, this.model.getSchemas(), code, data), DataSchema.class);
    }

    public void paramDef(String name, ParamLocation location, DataType schema, boolean isRequired, String description) {
        Map<String, Parameter> map = this.model.getParameters();
        Parameter parameter = new Parameter();
        String string = name;
        parameter.setName(string);
        ParamLocation paramLocation = location;
        parameter.setLocation(paramLocation);
        DataType dataType = schema;
        ScriptBytecodeAdapter.setProperty((Object)dataType, null, (Object)parameter, (String)"dataType");
        boolean bl = isRequired;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)parameter, (String)"isRequired");
        String string2 = description;
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)parameter, (String)"description");
        ValidationUtils.addUnique(SUB_PARAM, map, name, parameter);
    }

    public void paramDef(String code, Parameter param) {
        ValidationUtils.addUnique(SUB_PARAM, this.model.getParameters(), code, param);
    }

    public List<Parameter> params(List paramList) {
        Reference result = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _params_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference result;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _params_closure5(Object _outerInstance, Object _thisObject, Reference result) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.result = reference = result;
            }

            public Object doCall(Object it) {
                if (it instanceof String) {
                    return DefaultGroovyMethods.addAll((Collection)((Collection)ScriptBytecodeAdapter.castToType((Object)this.result.get(), Collection.class)), (Object[])new Object[]{((RestServicesBuilder)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), RestServicesBuilder.class)).paramRef(ShortTypeHandling.castToString((Object)it))});
                }
                if (it instanceof List) {
                    if (((List)it).size() == 2) {
                        DataSchema schema = ((RestServicesBuilder)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), RestServicesBuilder.class)).dataRef(ShortTypeHandling.castToString(((List)it).get(0)));
                        Reference location = new Reference((Object)((ParamLocation)ShortTypeHandling.castToEnum(((List)it).get(1), ParamLocation.class)));
                        public final class _closure8
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference result;
                            private /* synthetic */ Reference location;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure8(Object _outerInstance, Object _thisObject, Reference result, Reference location) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                this.result = reference2 = result;
                                this.location = reference = location;
                            }

                            public Object doCall(Object it) {
                                List list = (List)this.result.get();
                                Parameter parameter = new Parameter();
                                String string = ((DataSchema)it).getCode();
                                parameter.setName(string);
                                Object object = this.location.get();
                                parameter.setLocation((ParamLocation)ShortTypeHandling.castToEnum((Object)object, ParamLocation.class));
                                DataType dataType = ((DataSchema)it).getDataType();
                                ScriptBytecodeAdapter.setProperty((Object)dataType, null, (Object)parameter, (String)"dataType");
                                boolean bl = ((DataSchema)it).isIsRequired();
                                ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)parameter, (String)"isRequired");
                                String string2 = ((DataSchema)it).getDescription();
                                ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)parameter, (String)"description");
                                String string3 = ((DataSchema)it).getFormat();
                                ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)parameter, (String)"format");
                                return list.add(parameter);
                            }

                            public List getResult() {
                                return (List)ScriptBytecodeAdapter.castToType((Object)this.result.get(), List.class);
                            }

                            public Object getLocation() {
                                return this.location.get();
                            }

                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure8.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        return DefaultGroovyMethods.each(((ObjectType)ScriptBytecodeAdapter.castToType((Object)schema.getDataType(), ObjectType.class)).getFields(), (Closure)new _closure8((Object)this, this.getThisObject(), this.result, location));
                    }
                    if (((List)it).size() == 5) {
                        List list = (List)this.result.get();
                        Parameter parameter = new Parameter();
                        String string = ShortTypeHandling.castToString(((List)it).get(0));
                        parameter.setName(string);
                        ParamLocation paramLocation = (ParamLocation)ShortTypeHandling.castToEnum(((List)it).get(1), ParamLocation.class);
                        parameter.setLocation(paramLocation);
                        DataType dataType = (DataType)ScriptBytecodeAdapter.castToType(((List)it).get(2), DataType.class);
                        ScriptBytecodeAdapter.setProperty((Object)dataType, null, (Object)parameter, (String)"dataType");
                        Boolean bl = (Boolean)ScriptBytecodeAdapter.castToType(((List)it).get(3), Boolean.class);
                        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)parameter, (String)"isRequired");
                        String string2 = ShortTypeHandling.castToString(((List)it).get(4));
                        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)parameter, (String)"description");
                        return list.add(parameter);
                    }
                    throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{it}, new String[]{"Can't define param: ", ""})));
                }
                return null;
            }

            public List getResult() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.result.get(), List.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _params_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((List)paramList, (Closure)new _params_closure5(this, this, result));
        return (List)result.get();
    }

    public void responseDef(int code, String schemaRef, String description, String contentType) {
        ValidationUtils.addUnique(SUB_RESP, this.model.getResponses(), code, this.response(code, schemaRef, description, contentType));
    }

    public HttpResponse response(int code, String schemaRef, String description, String contentType) {
        HttpResponse httpResponse = new HttpResponse();
        int n = code;
        httpResponse.setStatus(n);
        DataSchema dataSchema = this.dataRef(schemaRef);
        httpResponse.setSchema(dataSchema);
        String string = description;
        httpResponse.setDescription(string);
        String string2 = contentType;
        httpResponse.setContentType(string2);
        return httpResponse;
    }

    public List<HttpResponse> responses(List responseList) {
        public final class _responses_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _responses_closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return it instanceof HttpResponse ? it : ((RestServicesBuilder)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), RestServicesBuilder.class)).responseRef((Integer)ScriptBytecodeAdapter.castToType((Object)it, Integer.class));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _responses_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.collect((Iterable)responseList, (Closure)new _responses_closure6(this, this));
    }

    public DataSchema dataRef(String code) {
        return (DataSchema)ScriptBytecodeAdapter.castToType((Object)this.getRequired(SUB_SCHEMA, code), DataSchema.class);
    }

    public HttpResponse responseRef(Integer responseCode) {
        return (HttpResponse)ScriptBytecodeAdapter.castToType((Object)this.getRequired(SUB_RESP, responseCode), HttpResponse.class);
    }

    public Parameter paramRef(String code) {
        return (Parameter)ScriptBytecodeAdapter.castToType((Object)this.getRequired(SUB_PARAM, code), Parameter.class);
    }

    public Object getRequired(String subject, Object key) {
        Object result = RestServicesBuilder.getValue(this.model, subject, key);
        if (!DefaultTypeTransformation.booleanUnbox((Object)result)) {
            StringBuffer stringBuffer = new StringBuffer("result. Values: ");
            stringBuffer.append((Object)"result = ");
            stringBuffer.append(InvokerHelper.toString((Object)result));
            ScriptBytecodeAdapter.assertFailed((Object)stringBuffer, (Object)new GStringImpl(new Object[]{subject, key}, new String[]{"", " ", " not defined"}));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static Object getValue(RestServices model, String subject, Object key) {
        void var2_2;
        Reference subject2 = new Reference((Object)subject);
        Reference key2 = new Reference((Object)var2_2);
        Map<String, Parameter> map = ScriptBytecodeAdapter.compareEqual((Object)((String)subject2.get()), (Object)SUB_SCHEMA) ? model.getSchemas() : (ScriptBytecodeAdapter.compareEqual((Object)((String)subject2.get()), (Object)SUB_PARAM) ? model.getParameters() : (Map<String, Parameter>)ScriptBytecodeAdapter.castToType(ScriptBytecodeAdapter.compareEqual((Object)((String)subject2.get()), (Object)SUB_RESP) ? model.getResponses() : null, Map.class));
        public final class _getValue_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference subject;
            private /* synthetic */ Reference key;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getValue_closure7(Object _outerInstance, Object _thisObject, Reference subject, Reference key) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.subject = reference2 = subject;
                this.key = reference = key;
            }

            public Object doCall(Object it) {
                return RestServicesBuilder.getValue((RestServices)ScriptBytecodeAdapter.castToType((Object)it, RestServices.class), ShortTypeHandling.castToString((Object)this.subject.get()), this.key.get());
            }

            public String getSubject() {
                return ShortTypeHandling.castToString((Object)this.subject.get());
            }

            public Object getKey() {
                return this.key.get();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getValue_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return map.containsKey(key2.get()) ? map.get(key2.get()) : DefaultGroovyMethods.findResult(model.getDependencies(), (Closure)new _getValue_closure7(RestServicesBuilder.class, RestServicesBuilder.class, subject2, key2));
    }

    public static String getResourceCode(String operationId) {
        String string;
        String resourceCode = ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])operationId.split("\\."), (int)0));
        resourceCode = string = StringGroovyMethods.capitalize((CharSequence)resourceCode);
        return resourceCode;
    }

    public static String getOperationCode(String operationId) {
        String text = ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])operationId.split("\\."), (int)1));
        StringBuffer buf = new StringBuffer();
        boolean toLowerCase = true;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (DefaultGroovyMethods.isUpperCase((Character)Character.valueOf(c))) {
                boolean bl;
                if (toLowerCase) {
                    char c2;
                    c = c2 = DefaultGroovyMethods.toLowerCase((Character)Character.valueOf(c));
                }
                toLowerCase = bl = true;
            } else {
                boolean bl;
                toLowerCase = bl = false;
            }
            buf.append(c);
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return buf.toString();
    }

    @Generated
    public void responseDef(int code, String schemaRef, String description) {
        this.responseDef(code, schemaRef, description, null);
    }

    @Generated
    public HttpResponse response(int code, String schemaRef, String description) {
        return this.response(code, schemaRef, description, null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RestServicesBuilder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        List list;
        OPERATIONS_WITH_BODY = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{OperationType.POST, OperationType.UPDATE, OperationType.PUT, OperationType.PATCH});
    }

    @Generated
    public static List<OperationType> getOPERATIONS_WITH_BODY() {
        return OPERATIONS_WITH_BODY;
    }

    @Generated
    public RestServices getModel() {
        return this.model;
    }

    @Generated
    public void setModel(RestServices restServices) {
        this.model = restServices;
    }
}

