/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.impl.serializers;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import pl.grzeslowski.jsupla.Preconditions;
import pl.grzeslowski.jsupla.protocoljava.api.serializers.StringSerializer;

public class StringSerializerImpl
implements StringSerializer {
    public static final StringSerializerImpl INSTANCE = new StringSerializerImpl();
    private static final int HEX_STRING_SUPPORTED_LENGTH = 32;

    @Override
    public byte[] serialize(String string, int length) {
        byte[] bytes = new byte[length];
        byte[] stringBytes = this.getBytesFromString(string);
        if (stringBytes.length > length) {
            throw new IllegalArgumentException(String.format("String [%s] has too many bytes [%s] to fit in byte array of size [%s]", string, stringBytes.length, length));
        }
        System.arraycopy(stringBytes, 0, bytes, 0, stringBytes.length);
        return bytes;
    }

    @Override
    public byte[] serialize(String string) {
        return this.serialize(string, this.getBytesFromString(string).length);
    }

    private byte[] getBytesFromString(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public byte[] serializePassword(char[] password, int length) {
        CharBuffer charBuffer = CharBuffer.wrap(password);
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(byteBuffer.array(), (byte)0);
        Preconditions.max((int)bytes.length, (int)length);
        byte[] passwordBytes = new byte[length];
        System.arraycopy(bytes, 0, passwordBytes, 0, bytes.length);
        return passwordBytes;
    }

    @Override
    public byte[] serializeHexString(String hex) {
        if (hex.length() != 32) {
            throw new IllegalArgumentException(String.format("This length of string %s (%s) is not supported. Only length that is supported is %s", hex, hex.length(), 32));
        }
        byte[] bytes = new byte[16];
        for (int i = 0; i < hex.length() - 1; i += 2) {
            char first = hex.charAt(i);
            char second = hex.charAt(i + 1);
            int hexValue = Integer.parseInt("" + first + second, 16);
            bytes[i / 2] = (byte)hexValue;
        }
        return bytes;
    }
}

