/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.impl.parsers.sd;

import java.util.Objects;
import javax.validation.constraints.NotNull;
import pl.grzeslowski.jsupla.protocol.api.structs.sd.ServerDevice;
import pl.grzeslowski.jsupla.protocol.api.structs.sd.SuplaChannelNewValue;
import pl.grzeslowski.jsupla.protocol.api.structs.sd.SuplaFirmwareUpdateUrlResult;
import pl.grzeslowski.jsupla.protocol.api.structs.sd.SuplaRegisterDeviceResult;
import pl.grzeslowski.jsupla.protocoljava.api.entities.sd.ServerDeviceEntity;
import pl.grzeslowski.jsupla.protocoljava.api.parsers.sd.ChannelNewValueParser;
import pl.grzeslowski.jsupla.protocoljava.api.parsers.sd.FirmwareUpdateUrlResultParser;
import pl.grzeslowski.jsupla.protocoljava.api.parsers.sd.RegisterDeviceResultParser;
import pl.grzeslowski.jsupla.protocoljava.api.parsers.sd.ServerDeviceParser;

public class ServerDeviceParserImpl
implements ServerDeviceParser<ServerDeviceEntity, ServerDevice> {
    private final ChannelNewValueParser channelNewValueParser;
    private final FirmwareUpdateUrlResultParser firmwareUpdateUrlResultParser;
    private final RegisterDeviceResultParser registerDeviceResultParser;

    public ServerDeviceParserImpl(ChannelNewValueParser channelNewValueParser, FirmwareUpdateUrlResultParser firmwareUpdateUrlResultParser, RegisterDeviceResultParser registerDeviceResultParser) {
        this.channelNewValueParser = Objects.requireNonNull(channelNewValueParser);
        this.firmwareUpdateUrlResultParser = Objects.requireNonNull(firmwareUpdateUrlResultParser);
        this.registerDeviceResultParser = Objects.requireNonNull(registerDeviceResultParser);
    }

    @Override
    public ServerDeviceEntity parse(@NotNull ServerDevice proto) {
        Objects.requireNonNull(proto);
        if (proto instanceof SuplaChannelNewValue) {
            return (ServerDeviceEntity)this.channelNewValueParser.parse((SuplaChannelNewValue)proto);
        }
        if (proto instanceof SuplaFirmwareUpdateUrlResult) {
            return (ServerDeviceEntity)this.firmwareUpdateUrlResultParser.parse((SuplaFirmwareUpdateUrlResult)proto);
        }
        if (proto instanceof SuplaRegisterDeviceResult) {
            return (ServerDeviceEntity)this.registerDeviceResultParser.parse((SuplaRegisterDeviceResult)proto);
        }
        throw new IllegalArgumentException(String.format("Don't know how to map this class \"%s\" to parser! %s", proto.getClass(), proto));
    }
}

