/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.impl.parsers;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import pl.grzeslowski.jsupla.Preconditions;
import pl.grzeslowski.jsupla.protocoljava.api.parsers.StringParser;

public class StringParserImpl
implements StringParser {
    public static final StringParserImpl INSTANCE = new StringParserImpl();
    private static final int HEX_LENGTH = 16;

    @Override
    public String parse(byte[] bytes) {
        return this.parseGenericString(bytes, 0, bytes.length, "UTF-8");
    }

    private String parseGenericString(byte[] bytes, int offset, int length, String charset) {
        Preconditions.sizeMin((byte[])bytes, (int)(offset + length));
        int end = length;
        for (int i = offset; i < length; ++i) {
            if (bytes[i] != 0) continue;
            end = i - offset;
            break;
        }
        try {
            return new String(bytes, offset, end, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public char[] parsePassword(byte[] utfBytes) {
        Charset charset = Charset.forName("UTF-8");
        CharBuffer charBuffer = charset.decode(ByteBuffer.wrap(utfBytes));
        return charBuffer.array();
    }

    @Override
    public String parseHexString(byte[] bytes) {
        Preconditions.checkArrayLength((byte[])bytes, (int)16);
        return String.format("%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X", bytes[0], bytes[1], bytes[2], bytes[3], bytes[4], bytes[5], bytes[6], bytes[7], bytes[8], bytes[9], bytes[10], bytes[11], bytes[12], bytes[13], bytes[14], bytes[15]);
    }
}

