/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.impl.parsers;

import java.util.Objects;
import javax.validation.constraints.NotNull;
import pl.grzeslowski.jsupla.protocol.api.structs.SuplaChannelValue;
import pl.grzeslowski.jsupla.protocol.api.structs.SuplaTimeval;
import pl.grzeslowski.jsupla.protocol.api.structs.cs.ClientServer;
import pl.grzeslowski.jsupla.protocol.api.structs.dcs.DeviceClientServer;
import pl.grzeslowski.jsupla.protocol.api.structs.ds.DeviceServer;
import pl.grzeslowski.jsupla.protocol.api.structs.ds.SuplaDeviceChannel;
import pl.grzeslowski.jsupla.protocol.api.structs.ds.SuplaDeviceChannelB;
import pl.grzeslowski.jsupla.protocol.api.structs.sc.ServerClient;
import pl.grzeslowski.jsupla.protocol.api.structs.sd.ServerDevice;
import pl.grzeslowski.jsupla.protocol.api.structs.sd.SuplaFirmwareUpdateUrl;
import pl.grzeslowski.jsupla.protocol.api.structs.sdc.ServerDeviceClient;
import pl.grzeslowski.jsupla.protocol.api.types.Proto;
import pl.grzeslowski.jsupla.protocoljava.api.entities.cs.ClientServerEntity;
import pl.grzeslowski.jsupla.protocoljava.api.entities.dcs.DeviceClientServerEntity;
import pl.grzeslowski.jsupla.protocoljava.api.entities.ds.DeviceServerEntity;
import pl.grzeslowski.jsupla.protocoljava.api.entities.sc.ServerClientEntity;
import pl.grzeslowski.jsupla.protocoljava.api.entities.sd.ServerDeviceEntity;
import pl.grzeslowski.jsupla.protocoljava.api.entities.sdc.ServerDeviceClientEntity;
import pl.grzeslowski.jsupla.protocoljava.api.parsers.ChannelValueParser;
import pl.grzeslowski.jsupla.protocoljava.api.parsers.Parser;
import pl.grzeslowski.jsupla.protocoljava.api.parsers.TimevalParser;
import pl.grzeslowski.jsupla.protocoljava.api.parsers.cs.ClientServerParser;
import pl.grzeslowski.jsupla.protocoljava.api.parsers.dcs.DeviceClientServerParser;
import pl.grzeslowski.jsupla.protocoljava.api.parsers.ds.DeviceChannelBParser;
import pl.grzeslowski.jsupla.protocoljava.api.parsers.ds.DeviceChannelParser;
import pl.grzeslowski.jsupla.protocoljava.api.parsers.ds.DeviceServerParser;
import pl.grzeslowski.jsupla.protocoljava.api.parsers.sc.ServerClientParser;
import pl.grzeslowski.jsupla.protocoljava.api.parsers.sd.FirmwareUpdateUrlParser;
import pl.grzeslowski.jsupla.protocoljava.api.parsers.sd.ServerDeviceParser;
import pl.grzeslowski.jsupla.protocoljava.api.parsers.sdc.ServerDeviceClientParser;
import pl.grzeslowski.jsupla.protocoljava.api.types.Entity;

public class ParserImpl
implements Parser<Entity, Proto> {
    private final ClientServerParser<ClientServerEntity, ClientServer> clientServerParserFactory;
    private final DeviceClientServerParser<DeviceClientServerEntity, DeviceClientServer> deviceClientServerParserFactory;
    private final DeviceServerParser<DeviceServerEntity, DeviceServer> deviceServerParserFactory;
    private final ServerClientParser<ServerClientEntity, ServerClient> serverClientParserFactory;
    private final ServerDeviceParser<ServerDeviceEntity, ServerDevice> serverDeviceParserFactory;
    private final ServerDeviceClientParser<ServerDeviceClientEntity, ServerDeviceClient> serverDeviceClientParserFactory;
    private final DeviceChannelParser deviceChannelParser;
    private final DeviceChannelBParser deviceChannelBParser;
    private final FirmwareUpdateUrlParser firmwareUpdateUrlParser;
    private final ChannelValueParser channelValueParser;
    private final TimevalParser timevalParser;

    public ParserImpl(ClientServerParser<ClientServerEntity, ClientServer> clientServerParserFactory, DeviceClientServerParser<DeviceClientServerEntity, DeviceClientServer> deviceClientServerParserFactory, DeviceServerParser<DeviceServerEntity, DeviceServer> deviceServerParserFactory, ServerClientParser<ServerClientEntity, ServerClient> serverClientParserFactory, ServerDeviceParser<ServerDeviceEntity, ServerDevice> serverDeviceParserFactory, ServerDeviceClientParser<ServerDeviceClientEntity, ServerDeviceClient> serverDeviceClientParserFactory, DeviceChannelParser deviceChannelParser, DeviceChannelBParser deviceChannelBParser, FirmwareUpdateUrlParser firmwareUpdateUrlParser, ChannelValueParser channelValueParser, TimevalParser timevalParser) {
        this.clientServerParserFactory = Objects.requireNonNull(clientServerParserFactory);
        this.deviceClientServerParserFactory = Objects.requireNonNull(deviceClientServerParserFactory);
        this.deviceServerParserFactory = Objects.requireNonNull(deviceServerParserFactory);
        this.serverClientParserFactory = Objects.requireNonNull(serverClientParserFactory);
        this.serverDeviceParserFactory = Objects.requireNonNull(serverDeviceParserFactory);
        this.serverDeviceClientParserFactory = Objects.requireNonNull(serverDeviceClientParserFactory);
        this.deviceChannelParser = Objects.requireNonNull(deviceChannelParser);
        this.deviceChannelBParser = Objects.requireNonNull(deviceChannelBParser);
        this.firmwareUpdateUrlParser = Objects.requireNonNull(firmwareUpdateUrlParser);
        this.channelValueParser = Objects.requireNonNull(channelValueParser);
        this.timevalParser = Objects.requireNonNull(timevalParser);
    }

    @Override
    public Entity parse(@NotNull Proto proto) {
        Objects.requireNonNull(proto);
        if (proto instanceof ClientServer) {
            return this.clientServerParserFactory.parse((ClientServer)proto);
        }
        if (proto instanceof DeviceClientServer) {
            return this.deviceClientServerParserFactory.parse((DeviceClientServer)proto);
        }
        if (proto instanceof DeviceServer) {
            return this.deviceServerParserFactory.parse((DeviceServer)proto);
        }
        if (proto instanceof ServerClient) {
            return this.serverClientParserFactory.parse((ServerClient)proto);
        }
        if (proto instanceof ServerDevice) {
            return this.serverDeviceParserFactory.parse((ServerDevice)proto);
        }
        if (proto instanceof ServerDeviceClient) {
            return this.serverDeviceClientParserFactory.parse((ServerDeviceClient)proto);
        }
        return this.commonProto(proto);
    }

    private Entity commonProto(@NotNull Proto proto) {
        if (proto instanceof SuplaDeviceChannel) {
            return this.deviceChannelParser.parse((SuplaDeviceChannel)proto);
        }
        if (proto instanceof SuplaDeviceChannelB) {
            return this.deviceChannelBParser.parse((SuplaDeviceChannelB)proto);
        }
        if (proto instanceof SuplaFirmwareUpdateUrl) {
            return this.firmwareUpdateUrlParser.parse((SuplaFirmwareUpdateUrl)proto);
        }
        if (proto instanceof SuplaChannelValue) {
            return this.channelValueParser.parse((SuplaChannelValue)proto);
        }
        if (proto instanceof SuplaTimeval) {
            return this.timevalParser.parse((SuplaTimeval)proto);
        }
        throw new IllegalArgumentException(String.format("Don't know how to map this class \"%s\" to parser! %s", proto.getClass(), proto));
    }
}

