/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.impl.decoders.channels.decoders;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import pl.grzeslowski.jsupla.Preconditions;
import pl.grzeslowski.jsupla.protocol.impl.decoders.PrimitiveDecoderImpl;
import pl.grzeslowski.jsupla.protocoljava.api.channels.decoders.ThermometerTypeChannelDecoder;
import pl.grzeslowski.jsupla.protocoljava.api.channels.values.ChannelValue;
import pl.grzeslowski.jsupla.protocoljava.api.channels.values.TemperatureAndHumidityValue;
import pl.grzeslowski.jsupla.protocoljava.api.channels.values.TemperatureValue;

public class ThermometerTypeChannelDecoderImpl
implements ThermometerTypeChannelDecoder {
    private static final int MINIMAL_SIZE = 4;
    private static final int PRECISION = 6;
    private static final MathContext DIVIDE_MATH_CONTEXT = new MathContext(6, RoundingMode.CEILING);
    private static final BigDecimal DIVISOR = new BigDecimal(1000);

    public ChannelValue decode(byte[] bytes, int offset) {
        Preconditions.sizeMin((byte[])bytes, (int)(offset + 4));
        int temperatureInt = PrimitiveDecoderImpl.INSTANCE.parseInt(bytes, offset);
        BigDecimal temperature = this.parseDoubleValue(temperatureInt);
        if (bytes.length < offset + 8) {
            return new TemperatureValue(temperature);
        }
        int humidityInt = PrimitiveDecoderImpl.INSTANCE.parseInt(bytes, offset + 4);
        BigDecimal humidity = this.parseDoubleValue(humidityInt);
        return new TemperatureAndHumidityValue(temperature, humidity);
    }

    private BigDecimal parseDoubleValue(int humidityInt) {
        return new BigDecimal(humidityInt).divide(DIVISOR, DIVIDE_MATH_CONTEXT);
    }
}

