/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.impl.decoders.channels.decoders;

import java.util.Objects;
import pl.grzeslowski.jsupla.protocoljava.api.channels.decoders.ChannelType;
import pl.grzeslowski.jsupla.protocoljava.api.channels.decoders.ChannelTypeDecoder;
import pl.grzeslowski.jsupla.protocoljava.api.channels.decoders.ColorTypeChannelDecoder;
import pl.grzeslowski.jsupla.protocoljava.api.channels.decoders.RelayTypeChannelDecoder;
import pl.grzeslowski.jsupla.protocoljava.api.channels.decoders.ThermometerTypeChannelDecoder;
import pl.grzeslowski.jsupla.protocoljava.api.channels.values.ChannelValue;
import pl.grzeslowski.jsupla.protocoljava.api.channels.values.UnknownValue;

public final class ChannelTypeDecoderImpl
implements ChannelTypeDecoder {
    private final ColorTypeChannelDecoder colorTypeChannelDecoder;
    private final RelayTypeChannelDecoder relayTypeChannelDecoder;
    private final ThermometerTypeChannelDecoder thermometerTypeChannelDecoder;

    public ChannelTypeDecoderImpl(ColorTypeChannelDecoder colorTypeChannelDecoder, RelayTypeChannelDecoder relayTypeChannelDecoder, ThermometerTypeChannelDecoder thermometerTypeChannelDecoder) {
        this.colorTypeChannelDecoder = Objects.requireNonNull(colorTypeChannelDecoder);
        this.relayTypeChannelDecoder = Objects.requireNonNull(relayTypeChannelDecoder);
        this.thermometerTypeChannelDecoder = Objects.requireNonNull(thermometerTypeChannelDecoder);
    }

    @Override
    public ChannelValue decode(ChannelType channelType, byte[] value) {
        switch (channelType) {
            case SUPLA_CHANNELTYPE_SENSORNO: 
            case SUPLA_CHANNELTYPE_SENSORNC: 
            case SUPLA_CHANNELTYPE_RELAYHFD4: 
            case SUPLA_CHANNELTYPE_RELAYG5LA1A: 
            case SUPLA_CHANNELTYPE_2XRELAYG5LA1A: 
            case SUPLA_CHANNELTYPE_RELAY: {
                return this.relayTypeChannelDecoder.decode(value);
            }
            case SUPLA_CHANNELTYPE_THERMOMETERDS18B20: {
                return (ChannelValue)this.thermometerTypeChannelDecoder.decode(value);
            }
            case SUPLA_CHANNELTYPE_DHT11: 
            case SUPLA_CHANNELTYPE_DHT22: 
            case SUPLA_CHANNELTYPE_DHT21: 
            case SUPLA_CHANNELTYPE_AM2302: 
            case SUPLA_CHANNELTYPE_AM2301: {
                return (ChannelValue)this.thermometerTypeChannelDecoder.decode(value);
            }
            case SUPLA_CHANNELTYPE_DIMMER: 
            case SUPLA_CHANNELTYPE_RGBLEDCONTROLLER: 
            case SUPLA_CHANNELTYPE_DIMMERANDRGBLED: 
            case SUPLA_CHANNELTYPE_DISTANCESENSOR: {
                return this.colorTypeChannelDecoder.decode(value);
            }
            case UNKNOWN: {
                return UnknownValue.UNKNOWN_VALUE;
            }
        }
        return new UnknownValue(value, String.format("Don't know how to map channel type %s to channel value!", new Object[]{channelType}));
    }
}

