/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.api.entities.sdc;

import javax.validation.constraints.Max;
import javax.validation.constraints.PositiveOrZero;
import pl.grzeslowski.jsupla.Preconditions;
import pl.grzeslowski.jsupla.protocoljava.api.entities.sdc.ServerDeviceClientEntity;

public class VersionError
implements ServerDeviceClientEntity {
    @PositiveOrZero
    @Max(value=255L)
    private final @PositiveOrZero @Max(value=255L) int serverVersionMin;
    @PositiveOrZero
    @Max(value=255L)
    private final @PositiveOrZero @Max(value=255L) int serverVersion;

    public VersionError(@PositiveOrZero @Max(value=255L) @PositiveOrZero @Max(value=255L) int serverVersionMin, @PositiveOrZero @Max(value=255L) @PositiveOrZero @Max(value=255L) int serverVersion) {
        this.serverVersionMin = Preconditions.unsignedByteSize((int)serverVersionMin);
        this.serverVersion = Preconditions.unsignedByteSize((int)serverVersion);
        Preconditions.max((int)serverVersionMin, (int)serverVersion);
    }

    public int getServerVersionMin() {
        return this.serverVersionMin;
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VersionError)) {
            return false;
        }
        VersionError that = (VersionError)o;
        if (this.serverVersionMin != that.serverVersionMin) {
            return false;
        }
        return this.serverVersion == that.serverVersion;
    }

    public final int hashCode() {
        int result = this.serverVersionMin;
        result = 31 * result + this.serverVersion;
        return result;
    }

    public String toString() {
        return "VersionError{serverVersionMin=" + this.serverVersionMin + ", serverVersion=" + this.serverVersion + '}';
    }
}

