/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.api.entities.sdc;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.PositiveOrZero;
import javax.validation.constraints.Size;
import pl.grzeslowski.jsupla.Preconditions;
import pl.grzeslowski.jsupla.protocoljava.api.entities.sdc.ServerDeviceClientEntity;

public class GetVersionResult
implements ServerDeviceClientEntity {
    @PositiveOrZero
    @Max(value=255L)
    private final @PositiveOrZero @Max(value=255L) int protoVersionMin;
    @PositiveOrZero
    @Max(value=255L)
    private final @PositiveOrZero @Max(value=255L) int protoVersion;
    @NotNull
    @Size(min=1, max=21)
    private final @NotNull @Size(min=1, max=21) String softVer;

    public GetVersionResult(@PositiveOrZero @Max(value=255L) @PositiveOrZero @Max(value=255L) int protoVersionMin, @PositiveOrZero @Max(value=255L) @PositiveOrZero @Max(value=255L) int protoVersion, @NotNull @Size(min=1, max=21) @NotNull @Size(min=1, max=21) String softVer) {
        this.protoVersionMin = Preconditions.positiveOrZero((int)Preconditions.unsignedByteSize((int)protoVersionMin));
        this.protoVersion = Preconditions.positiveOrZero((int)Preconditions.unsignedByteSize((int)protoVersion));
        this.softVer = (String)Preconditions.size((CharSequence)softVer, (int)1, (int)21);
        Preconditions.max((int)protoVersionMin, (int)protoVersion);
    }

    public int getProtoVersionMin() {
        return this.protoVersionMin;
    }

    public int getProtoVersion() {
        return this.protoVersion;
    }

    public String getSoftVer() {
        return this.softVer;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetVersionResult)) {
            return false;
        }
        GetVersionResult that = (GetVersionResult)o;
        if (this.protoVersionMin != that.protoVersionMin) {
            return false;
        }
        if (this.protoVersion != that.protoVersion) {
            return false;
        }
        return this.softVer.equals(that.softVer);
    }

    public final int hashCode() {
        int result = this.protoVersionMin;
        result = 31 * result + this.protoVersion;
        result = 31 * result + this.softVer.hashCode();
        return result;
    }

    public String toString() {
        return "GetVersionResult{protoVersionMin=" + this.protoVersionMin + ", protoVersion=" + this.protoVersion + ", softVer='" + this.softVer + '\'' + '}';
    }
}

