/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.api.entities.sd;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.PositiveOrZero;
import pl.grzeslowski.jsupla.Preconditions;
import pl.grzeslowski.jsupla.protocoljava.api.entities.sd.ServerDeviceEntity;

public class RegisterDeviceResult
implements ServerDeviceEntity {
    private final int resultCode;
    @PositiveOrZero
    @Max(value=127L)
    private final @PositiveOrZero @Max(value=127L) int activityTimeout;
    @Min(value=-128L)
    @Max(value=127L)
    private final @Min(value=-128L) @Max(value=127L) int version;
    @Min(value=-128L)
    @Max(value=127L)
    private final @Min(value=-128L) @Max(value=127L) int versionMin;

    public RegisterDeviceResult(int resultCode, @PositiveOrZero @Max(value=127L) @PositiveOrZero @Max(value=127L) int activityTimeout, @Min(value=-128L) @Max(value=127L) @Min(value=-128L) @Max(value=127L) int version, @Min(value=-128L) @Max(value=127L) @Min(value=-128L) @Max(value=127L) int versionMin) {
        this.resultCode = resultCode;
        this.activityTimeout = Preconditions.positiveOrZero((int)Preconditions.byteSize((int)activityTimeout));
        this.version = Preconditions.byteSize((int)version);
        this.versionMin = Preconditions.byteSize((int)versionMin);
        Preconditions.min((int)version, (int)versionMin);
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public int getActivityTimeout() {
        return this.activityTimeout;
    }

    public int getVersion() {
        return this.version;
    }

    public int getVersionMin() {
        return this.versionMin;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegisterDeviceResult)) {
            return false;
        }
        RegisterDeviceResult that = (RegisterDeviceResult)o;
        if (this.resultCode != that.resultCode) {
            return false;
        }
        if (this.activityTimeout != that.activityTimeout) {
            return false;
        }
        if (this.version != that.version) {
            return false;
        }
        return this.versionMin == that.versionMin;
    }

    public final int hashCode() {
        int result = this.resultCode;
        result = 31 * result + this.activityTimeout;
        result = 31 * result + this.version;
        result = 31 * result + this.versionMin;
        return result;
    }

    public String toString() {
        return "RegisterDeviceResult{resultCode=" + this.resultCode + ", activityTimeout=" + this.activityTimeout + ", version=" + this.version + ", versionMin=" + this.versionMin + '}';
    }
}

