/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.api.entities.sd;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import pl.grzeslowski.jsupla.Preconditions;
import pl.grzeslowski.jsupla.protocoljava.api.types.Entity;

public class FirmwareUpdateUrl
implements Entity {
    @Min(value=-128L)
    @Max(value=127L)
    private final @Min(value=-128L) @Max(value=127L) int availableProtocols;
    @NotNull
    @Size(min=1, max=101)
    private final @NotNull @Size(min=1, max=101) String host;
    @Min(value=0L)
    @Max(value=65535L)
    private final @Min(value=0L) @Max(value=65535L) int port;
    @NotNull
    @Size(min=1, max=101)
    private final @NotNull @Size(min=1, max=101) String path;

    public FirmwareUpdateUrl(@Min(value=-128L) @Max(value=127L) @Min(value=-128L) @Max(value=127L) int availableProtocols, @NotNull @Size(min=1, max=101) @NotNull @Size(min=1, max=101) String host, @Min(value=0L) @Max(value=65535L) @Min(value=0L) @Max(value=65535L) int port, @NotNull @Size(min=1, max=101) @NotNull @Size(min=1, max=101) String path) {
        this.availableProtocols = Preconditions.byteSize((int)availableProtocols);
        this.host = (String)Preconditions.size((CharSequence)host, (int)1, (int)101);
        this.port = Preconditions.size((int)port, (int)0, (int)65535);
        this.path = (String)Preconditions.size((CharSequence)path, (int)1, (int)101);
    }

    public int getAvailableProtocols() {
        return this.availableProtocols;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FirmwareUpdateUrl)) {
            return false;
        }
        FirmwareUpdateUrl that = (FirmwareUpdateUrl)o;
        if (this.availableProtocols != that.availableProtocols) {
            return false;
        }
        if (this.port != that.port) {
            return false;
        }
        if (!this.host.equals(that.host)) {
            return false;
        }
        return this.path.equals(that.path);
    }

    public final int hashCode() {
        int result = this.host.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        return "FirmwareUpdateUrl{availableProtocols=" + this.availableProtocols + ", host='" + this.host + '\'' + ", port=" + this.port + ", path='" + this.path + '\'' + '}';
    }
}

