/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.api.entities.sd;

import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import pl.grzeslowski.jsupla.Preconditions;
import pl.grzeslowski.jsupla.protocoljava.api.channels.values.ChannelValue;
import pl.grzeslowski.jsupla.protocoljava.api.entities.sd.ServerDeviceEntity;

public class ChannelNewValue
implements ServerDeviceEntity {
    @Min(value=1L)
    private final @Min(value=1L) int senderId;
    @Min(value=0L)
    @Max(value=255L)
    private final @Min(value=0L) @Max(value=255L) int channelNumber;
    @Min(value=0L)
    @Max(value=0xFFFFFFFFL)
    private final @Min(value=0L) @Max(value=0xFFFFFFFFL) long durationMs;
    @NotNull
    @Valid
    private final ChannelValue value;

    public ChannelNewValue(@Min(value=1L) @Min(value=1L) int senderId, @Min(value=0L) @Max(value=255L) @Min(value=0L) @Max(value=255L) int channelNumber, @Min(value=0L) @Max(value=0xFFFFFFFFL) @Min(value=0L) @Max(value=0xFFFFFFFFL) long durationMs, @NotNull @Valid ChannelValue value) {
        this.senderId = Preconditions.id((int)senderId);
        this.channelNumber = Preconditions.unsignedByteSize((int)channelNumber);
        this.durationMs = Preconditions.unsignedIntSize((long)durationMs);
        this.value = Objects.requireNonNull(value);
    }

    public int getSenderId() {
        return this.senderId;
    }

    public int getChannelNumber() {
        return this.channelNumber;
    }

    public long getDurationMs() {
        return this.durationMs;
    }

    public ChannelValue getValue() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChannelNewValue)) {
            return false;
        }
        ChannelNewValue that = (ChannelNewValue)o;
        if (this.senderId != that.senderId) {
            return false;
        }
        if (this.channelNumber != that.channelNumber) {
            return false;
        }
        if (this.durationMs != that.durationMs) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public final int hashCode() {
        return this.senderId;
    }

    public String toString() {
        return "ChannelNewValue{senderId=" + this.senderId + ", channelNumber=" + this.channelNumber + ", durationMs=" + this.durationMs + ", value=" + this.value + '}';
    }
}

