/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.api.entities.sc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.PositiveOrZero;
import javax.validation.constraints.Size;
import pl.grzeslowski.jsupla.Preconditions;
import pl.grzeslowski.jsupla.protocoljava.api.entities.sc.Location;
import pl.grzeslowski.jsupla.protocoljava.api.entities.sc.ServerClientEntity;

public class LocationPack
implements ServerClientEntity {
    @PositiveOrZero
    private final int totalLeft;
    @Size(min=1, max=20)
    private final @Size(min=1, max=20) List<Location> locations;

    public LocationPack(@PositiveOrZero int totalLeft, @Size(min=1, max=20) @Size(min=1, max=20) List<Location> locations) {
        this.totalLeft = Preconditions.sizeMin((int)totalLeft, (int)0);
        this.locations = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(Preconditions.size(locations, (int)1, (int)20))));
    }

    public int getTotalLeft() {
        return this.totalLeft;
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocationPack)) {
            return false;
        }
        LocationPack that = (LocationPack)o;
        if (this.totalLeft != that.totalLeft) {
            return false;
        }
        return this.locations.equals(that.locations);
    }

    public final int hashCode() {
        int result = this.totalLeft;
        result = 31 * result + this.locations.hashCode();
        return result;
    }

    public String toString() {
        return "LocationPack{totalLeft=" + this.totalLeft + ", locations=" + this.locations + '}';
    }
}

