/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.api.entities.sc;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import javax.validation.constraints.Size;
import pl.grzeslowski.jsupla.Preconditions;
import pl.grzeslowski.jsupla.protocoljava.api.entities.sc.ServerClientEntity;

public class Location
implements ServerClientEntity {
    @Min(value=-128L)
    @Max(value=127L)
    private final @Min(value=-128L) @Max(value=127L) int eol;
    @Positive
    @Min(value=1L)
    private final @Positive @Min(value=1L) int id;
    @NotNull
    @Size(min=1, max=401)
    private final @NotNull @Size(min=1, max=401) String caption;

    public Location(@Min(value=-128L) @Max(value=127L) @Min(value=-128L) @Max(value=127L) int eol, @Positive int id, @NotNull @Size(min=1, max=401) @NotNull @Size(min=1, max=401) String caption) {
        this.eol = Preconditions.byteSize((int)eol);
        this.id = Preconditions.min((int)id, (int)1);
        this.caption = (String)Preconditions.size((CharSequence)caption, (int)1, (int)401);
    }

    public int getEol() {
        return this.eol;
    }

    public int getId() {
        return this.id;
    }

    public String getCaption() {
        return this.caption;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location location = (Location)o;
        if (this.eol != location.eol) {
            return false;
        }
        if (this.id != location.id) {
            return false;
        }
        return this.caption.equals(location.caption);
    }

    public final int hashCode() {
        return this.id;
    }

    public String toString() {
        return "Location{eol=" + this.eol + ", id=" + this.id + ", caption='" + this.caption + '\'' + '}';
    }
}

