/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.api.entities.sc;

import javax.validation.constraints.Max;
import javax.validation.constraints.Positive;
import javax.validation.constraints.Size;
import pl.grzeslowski.jsupla.Preconditions;
import pl.grzeslowski.jsupla.protocoljava.api.entities.sc.ServerClientEntity;

public class Event
implements ServerClientEntity {
    private final int event;
    private final int channelId;
    @Positive
    @Max(value=0xFFFFFFFFL)
    private final @Positive @Max(value=0xFFFFFFFFL) long durationMs;
    private final int senderId;
    @Size(min=1, max=201)
    private final @Size(min=1, max=201) String senderName;

    public Event(int event, int channelId, @Positive @Max(value=0xFFFFFFFFL) @Positive @Max(value=0xFFFFFFFFL) long durationMs, int senderId, @Size(min=1, max=201) @Size(min=1, max=201) String senderName) {
        this.event = event;
        this.channelId = channelId;
        this.durationMs = Preconditions.unsignedIntSize((long)durationMs);
        this.senderId = senderId;
        this.senderName = (String)Preconditions.size((CharSequence)senderName, (int)1, (int)201);
    }

    public int getEvent() {
        return this.event;
    }

    public int getChannelId() {
        return this.channelId;
    }

    public long getDurationMs() {
        return this.durationMs;
    }

    public int getSenderId() {
        return this.senderId;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event event1 = (Event)o;
        if (this.event != event1.event) {
            return false;
        }
        if (this.channelId != event1.channelId) {
            return false;
        }
        if (this.durationMs != event1.durationMs) {
            return false;
        }
        if (this.senderId != event1.senderId) {
            return false;
        }
        return this.senderName.equals(event1.senderName);
    }

    public final int hashCode() {
        int result = this.event;
        result = 31 * result + this.channelId;
        return result;
    }

    public String toString() {
        return "Event{event=" + this.event + ", channelId=" + this.channelId + ", durationMs=" + this.durationMs + ", senderId=" + this.senderId + ", senderName='" + this.senderName + '\'' + '}';
    }
}

