/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.api.entities.sc;

import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import pl.grzeslowski.jsupla.Preconditions;
import pl.grzeslowski.jsupla.protocoljava.api.entities.sc.ServerClientEntity;

public class ChannelValue
implements ServerClientEntity {
    @Min(value=-128L)
    @Max(value=127L)
    private final @Min(value=-128L) @Max(value=127L) int eol;
    @Positive
    @Min(value=1L)
    private final @Positive @Min(value=1L) int id;
    private final boolean online;
    @NotNull
    @Valid
    private final pl.grzeslowski.jsupla.protocoljava.api.entities.ChannelValue value;

    public ChannelValue(@Min(value=-128L) @Max(value=127L) @Min(value=-128L) @Max(value=127L) int eol, @Positive @Min(value=1L) @Positive @Min(value=1L) int id, boolean online, @NotNull @Valid pl.grzeslowski.jsupla.protocoljava.api.entities.ChannelValue value) {
        this.eol = Preconditions.byteSize((int)eol);
        this.id = Preconditions.min((int)id, (int)1);
        this.online = online;
        this.value = Objects.requireNonNull(value);
    }

    public int getEol() {
        return this.eol;
    }

    public int getId() {
        return this.id;
    }

    public boolean isOnline() {
        return this.online;
    }

    public pl.grzeslowski.jsupla.protocoljava.api.entities.ChannelValue getValue() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChannelValue)) {
            return false;
        }
        ChannelValue that = (ChannelValue)o;
        if (this.eol != that.eol) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.online != that.online) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public final int hashCode() {
        return this.id;
    }

    public String toString() {
        return "ChannelValue{eol=" + this.eol + ", id=" + this.id + ", online=" + this.online + ", value=" + this.value + '}';
    }
}

