/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.api.entities.sc;

import java.util.Objects;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import pl.grzeslowski.jsupla.Preconditions;
import pl.grzeslowski.jsupla.protocoljava.api.entities.sc.ServerClientEntity;

public class ChannelGroup
implements ServerClientEntity {
    @Max(value=127L)
    @Min(value=-128L)
    private final @Max(value=127L) @Min(value=-128L) int eol;
    @Positive
    private final int id;
    @Positive
    private final int locationId;
    private final int function;
    private final int altIcon;
    @PositiveOrZero
    private final long flags;
    private final String caption;

    public ChannelGroup(@Max(value=127L) @Min(value=-128L) @Max(value=127L) @Min(value=-128L) int eol, @Positive int id, @Positive int locationId, int function, int altIcon, @PositiveOrZero long flags, String caption) {
        this.eol = Preconditions.byteSize((int)eol);
        this.id = Preconditions.positive((int)id);
        this.locationId = Preconditions.positive((int)locationId);
        this.function = function;
        this.altIcon = altIcon;
        this.flags = Preconditions.positiveOrZero((long)flags);
        this.caption = caption;
    }

    public int getEol() {
        return this.eol;
    }

    public int getId() {
        return this.id;
    }

    public int getLocationId() {
        return this.locationId;
    }

    public int getFunction() {
        return this.function;
    }

    public int getAltIcon() {
        return this.altIcon;
    }

    public long getFlags() {
        return this.flags;
    }

    public String getCaption() {
        return this.caption;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChannelGroup)) {
            return false;
        }
        ChannelGroup that = (ChannelGroup)o;
        return this.eol == that.eol && this.id == that.id && this.locationId == that.locationId && this.function == that.function && this.altIcon == that.altIcon && this.flags == that.flags && Objects.equals(this.caption, that.caption);
    }

    public final int hashCode() {
        return Objects.hash(this.eol, this.id, this.locationId, this.function, this.altIcon, this.flags, this.caption);
    }

    public String toString() {
        return "ChannelGroup{eol=" + this.eol + ", id=" + this.id + ", locationId=" + this.locationId + ", function=" + this.function + ", altIcon=" + this.altIcon + ", flags=" + this.flags + ", caption='" + this.caption + '\'' + '}';
    }
}

