/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.api.entities.sc;

import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import javax.validation.constraints.Size;
import pl.grzeslowski.jsupla.Preconditions;
import pl.grzeslowski.jsupla.protocoljava.api.entities.ChannelValue;
import pl.grzeslowski.jsupla.protocoljava.api.entities.sc.Channel;

public class ChannelB
extends Channel {
    private final int altIcon;
    @PositiveOrZero
    private final long flags;
    @Max(value=255L)
    @Min(value=0L)
    private final @Max(value=255L) @Min(value=0L) int protocolVersion;

    public ChannelB(@Min(value=-128L) @Max(value=127L) @Min(value=-128L) @Max(value=127L) int eol, @Positive @Min(value=0L) @Positive @Min(value=0L) int id, int locationId, int function, boolean online, @NotNull @Valid ChannelValue channelValue, @NotNull @Size(min=1, max=401) @NotNull @Size(min=1, max=401) String caption, int altIcon, @PositiveOrZero long flags, @Min(value=0L) @Max(value=255L) @Min(value=0L) @Max(value=255L) int protocolVersion) {
        super(eol, id, locationId, function, online, channelValue, caption);
        this.altIcon = altIcon;
        this.flags = Preconditions.positiveOrZero((long)flags);
        this.protocolVersion = Preconditions.size((int)protocolVersion, (int)0, (int)255);
    }

    public int getAltIcon() {
        return this.altIcon;
    }

    public long getFlags() {
        return this.flags;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChannelB)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChannelB channelB = (ChannelB)o;
        if (!channelB.canEqual(this)) {
            return false;
        }
        return this.altIcon == channelB.altIcon && this.flags == channelB.flags && this.protocolVersion == channelB.protocolVersion;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ChannelB;
    }

    @Override
    public final int hashCode() {
        return Objects.hash(super.hashCode(), this.altIcon, this.flags, this.protocolVersion);
    }

    @Override
    public String toString() {
        return "ChannelB{altIcon=" + this.altIcon + ", flags=" + this.flags + ", protocolVersion=" + this.protocolVersion + "} " + super.toString();
    }
}

