/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.api.entities.sc;

import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import javax.validation.constraints.Size;
import pl.grzeslowski.jsupla.Preconditions;
import pl.grzeslowski.jsupla.protocoljava.api.entities.ChannelValue;
import pl.grzeslowski.jsupla.protocoljava.api.entities.sc.ServerClientEntity;

@Deprecated
public class Channel
implements ServerClientEntity {
    @Min(value=-128L)
    @Max(value=127L)
    private final @Min(value=-128L) @Max(value=127L) int eol;
    @Positive
    @Min(value=0L)
    private final @Positive @Min(value=0L) int id;
    private final int locationId;
    private final int function;
    private final boolean online;
    @NotNull
    @Valid
    private final ChannelValue channelValue;
    @NotNull
    @Size(min=1, max=401)
    private final @NotNull @Size(min=1, max=401) String caption;

    public Channel(@Min(value=-128L) @Max(value=127L) @Min(value=-128L) @Max(value=127L) int eol, @Positive @Min(value=0L) @Positive @Min(value=0L) int id, int locationId, int function, boolean online, @NotNull @Valid ChannelValue channelValue, @NotNull @Size(min=1, max=401) @NotNull @Size(min=1, max=401) String caption) {
        this.eol = Preconditions.byteSize((int)eol);
        this.id = Preconditions.min((int)id, (int)1);
        this.locationId = locationId;
        this.function = function;
        this.online = online;
        this.channelValue = Objects.requireNonNull(channelValue);
        this.caption = (String)Preconditions.size((CharSequence)caption, (int)1, (int)401);
    }

    public int getEol() {
        return this.eol;
    }

    public int getId() {
        return this.id;
    }

    public int getLocationId() {
        return this.locationId;
    }

    public int getFunction() {
        return this.function;
    }

    public boolean isOnline() {
        return this.online;
    }

    public ChannelValue getChannelValue() {
        return this.channelValue;
    }

    public String getCaption() {
        return this.caption;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Channel)) {
            return false;
        }
        Channel channel = (Channel)o;
        if (!channel.canEqual(this)) {
            return false;
        }
        return this.eol == channel.eol && this.id == channel.id && this.locationId == channel.locationId && this.function == channel.function && this.online == channel.online && Objects.equals(this.channelValue, channel.channelValue) && Objects.equals(this.caption, channel.caption);
    }

    protected boolean canEqual(Object other) {
        return other instanceof Channel;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "Channel{eol=" + this.eol + ", id=" + this.id + ", locationId=" + this.locationId + ", function=" + this.function + ", online=" + this.online + ", channelValue=" + this.channelValue + '}';
    }
}

