/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.api.entities.ds;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import pl.grzeslowski.jsupla.Preconditions;
import pl.grzeslowski.jsupla.protocoljava.api.entities.ds.DeviceChannelB;
import pl.grzeslowski.jsupla.protocoljava.api.entities.ds.DeviceServerEntity;

public class RegisterDeviceD
implements DeviceServerEntity {
    @Size(min=1, max=256)
    @NotNull
    private final @Size(min=1, max=256) @NotNull String email;
    @Size(min=1, max=16)
    @NotNull
    private final @Size(min=1, max=16) @NotNull String authKey;
    @Size(min=1, max=16)
    @NotNull
    private final @Size(min=1, max=16) @NotNull String guid;
    @Size(min=1, max=201)
    @NotNull
    private final @Size(min=1, max=201) @NotNull String name;
    @Size(min=1, max=21)
    @NotNull
    private final @Size(min=1, max=21) @NotNull String softVer;
    @Size(min=1, max=65)
    @NotNull
    private final @Size(min=1, max=65) @NotNull String serverName;
    @Size(min=1)
    @NotNull
    private final @Size(min=1) @NotNull List<DeviceChannelB> channels;

    public RegisterDeviceD(@Size(min=1, max=256) @NotNull @Size(min=1, max=256) @NotNull String email, @Size(min=1, max=16) @NotNull @Size(min=1, max=16) @NotNull String authKey, @Size(min=1, max=16) @NotNull @Size(min=1, max=16) @NotNull String guid, @Size(min=1, max=201) @NotNull @Size(min=1, max=201) @NotNull String name, @Size(min=1, max=21) @NotNull @Size(min=1, max=21) @NotNull String softVer, @Size(min=1, max=65) @NotNull @Size(min=1, max=65) @NotNull String serverName, @Size(min=1) @NotNull @Size(min=1) @NotNull List<DeviceChannelB> channels) {
        this.email = Preconditions.notEmpty((String)email);
        this.authKey = Preconditions.notEmpty((String)authKey);
        this.guid = Preconditions.notEmpty((String)guid);
        this.name = Preconditions.notEmpty((String)name);
        this.softVer = Preconditions.notEmpty((String)softVer);
        this.serverName = Preconditions.notEmpty((String)serverName);
        this.channels = Collections.unmodifiableList(Preconditions.sizeMin(channels, (int)1));
    }

    public String getEmail() {
        return this.email;
    }

    public String getAuthKey() {
        return this.authKey;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getName() {
        return this.name;
    }

    public String getSoftVer() {
        return this.softVer;
    }

    public String getServerName() {
        return this.serverName;
    }

    public List<DeviceChannelB> getChannels() {
        return this.channels;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegisterDeviceD)) {
            return false;
        }
        RegisterDeviceD that = (RegisterDeviceD)o;
        return Objects.equals(this.email, that.email) && Objects.equals(this.authKey, that.authKey) && Objects.equals(this.guid, that.guid) && Objects.equals(this.name, that.name) && Objects.equals(this.softVer, that.softVer) && Objects.equals(this.serverName, that.serverName) && Objects.equals(this.channels, that.channels);
    }

    public final int hashCode() {
        return Objects.hash(this.email, this.authKey, this.guid, this.name, this.softVer, this.serverName, this.channels);
    }

    public String toString() {
        return "RegisterDeviceD{email='" + this.email + '\'' + ", authKey=[PROTECTED], guid='" + this.guid + '\'' + ", name='" + this.name + '\'' + ", softVer='" + this.softVer + '\'' + ", serverName='" + this.serverName + '\'' + ", channels=" + this.channels + '}';
    }
}

