/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.api.entities.ds;

import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import pl.grzeslowski.jsupla.Preconditions;
import pl.grzeslowski.jsupla.protocoljava.api.channels.values.ChannelValue;
import pl.grzeslowski.jsupla.protocoljava.api.entities.ds.DeviceServerEntity;

public class DeviceChannelValue
implements DeviceServerEntity {
    @Min(value=0L)
    @Max(value=255L)
    private final @Min(value=0L) @Max(value=255L) int channelNumber;
    @Valid
    @NotNull
    private final ChannelValue value;

    public DeviceChannelValue(@Min(value=0L) @Max(value=255L) @Min(value=0L) @Max(value=255L) int channelNumber, @Valid @NotNull ChannelValue value) {
        this.channelNumber = Preconditions.unsignedByteSize((int)channelNumber);
        this.value = Objects.requireNonNull(value);
    }

    public int getChannelNumber() {
        return this.channelNumber;
    }

    public ChannelValue getValue() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeviceChannelValue)) {
            return false;
        }
        DeviceChannelValue that = (DeviceChannelValue)o;
        if (this.channelNumber != that.channelNumber) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public final int hashCode() {
        return this.channelNumber;
    }

    public String toString() {
        return "DeviceChannelValue{channelNumber=" + this.channelNumber + ", value=" + this.value + '}';
    }
}

