/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.api.entities.ds;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import pl.grzeslowski.jsupla.Preconditions;
import pl.grzeslowski.jsupla.protocoljava.api.entities.ds.DeviceServerEntity;

public class ChannelNewValueResult
implements DeviceServerEntity {
    @Min(value=0L)
    @Max(value=255L)
    private final @Min(value=0L) @Max(value=255L) int channelNumber;
    private final int senderId;
    private final boolean success;

    public ChannelNewValueResult(@Min(value=0L) @Max(value=255L) @Min(value=0L) @Max(value=255L) int channelNumber, int senderId, boolean success) {
        this.channelNumber = Preconditions.unsignedByteSize((int)channelNumber);
        this.senderId = senderId;
        this.success = success;
    }

    public int getChannelNumber() {
        return this.channelNumber;
    }

    public int getSenderId() {
        return this.senderId;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChannelNewValueResult)) {
            return false;
        }
        ChannelNewValueResult that = (ChannelNewValueResult)o;
        if (this.channelNumber != that.channelNumber) {
            return false;
        }
        if (this.senderId != that.senderId) {
            return false;
        }
        return this.success == that.success;
    }

    public final int hashCode() {
        int result = this.channelNumber;
        result = 31 * result + this.senderId;
        return result;
    }

    public String toString() {
        return "ChannelNewValueResult{channelNumber=" + this.channelNumber + ", senderId=" + this.senderId + ", success=" + this.success + '}';
    }
}

