/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.api.entities.cs;

import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import pl.grzeslowski.jsupla.Preconditions;
import pl.grzeslowski.jsupla.protocoljava.api.channels.values.ChannelValue;
import pl.grzeslowski.jsupla.protocoljava.api.entities.cs.ClientServerEntity;

public class NewValue
implements ClientServerEntity {
    @Positive
    private final int id;
    @Min(value=-128L)
    @Max(value=127L)
    private final @Min(value=-128L) @Max(value=127L) int target;
    @NotNull
    @Valid
    private final ChannelValue value;

    public NewValue(@Positive int id, @Min(value=-128L) @Max(value=127L) @Min(value=-128L) @Max(value=127L) int target, @NotNull @Valid ChannelValue value) {
        this.id = Preconditions.id((int)id);
        this.target = Preconditions.byteSize((int)target);
        this.value = Objects.requireNonNull(value);
    }

    public int getId() {
        return this.id;
    }

    public int getTarget() {
        return this.target;
    }

    public ChannelValue getValue() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NewValue)) {
            return false;
        }
        NewValue newValue = (NewValue)o;
        return this.id == newValue.id && this.target == newValue.target && Objects.equals(this.value, newValue.value);
    }

    public final int hashCode() {
        return Objects.hash(this.id, this.target, this.value);
    }

    public String toString() {
        return "NewValue{id=" + this.id + ", target=" + this.target + ", value=" + this.value + '}';
    }
}

