/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.api.entities;

import javax.validation.constraints.Min;
import javax.validation.constraints.PositiveOrZero;
import pl.grzeslowski.jsupla.Preconditions;
import pl.grzeslowski.jsupla.protocoljava.api.types.Entity;

public class Timeval
implements Entity {
    @PositiveOrZero
    @Min(value=0L)
    private final @PositiveOrZero @Min(value=0L) int seconds;
    @PositiveOrZero
    @Min(value=0L)
    private final @PositiveOrZero @Min(value=0L) int milliseconds;

    public Timeval(@PositiveOrZero int seconds, @PositiveOrZero int milliseconds) {
        this.seconds = Preconditions.positiveOrZero((int)seconds);
        this.milliseconds = Preconditions.positiveOrZero((int)milliseconds);
    }

    @PositiveOrZero
    public int getSeconds() {
        return this.seconds;
    }

    @PositiveOrZero
    public int getMilliseconds() {
        return this.milliseconds;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Timeval)) {
            return false;
        }
        Timeval timeval = (Timeval)o;
        if (this.seconds != timeval.seconds) {
            return false;
        }
        return this.milliseconds == timeval.milliseconds;
    }

    public final int hashCode() {
        return this.seconds;
    }

    public String toString() {
        return "Timeval{seconds=" + this.seconds + ", milliseconds=" + this.milliseconds + '}';
    }
}

